% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operators.R
\name{hessian}
\alias{hessian}
\alias{\%hessian\%}
\title{Numerical and Symbolic Hessian}
\usage{
hessian(f, var, accuracy = 2, stepsize = NULL,
  coordinates = "cartesian")

f \%hessian\% var
}
\arguments{
\item{f}{function, expression or character.}

\item{var}{character vector, giving the variable names with respect to which derivatives will be computed. If a named vector is provided, derivatives will be computed at that point.}

\item{accuracy}{accuracy degree for numerical derivatives.}

\item{stepsize}{finite differences stepsize for numerical derivatives. Auto-optimized by default.}

\item{coordinates}{coordinate system to use. One of: \code{cartesian}, \code{polar}, \code{spherical}, \code{cylindrical}, \code{parabolic}, \code{parabolic-cylindrical} or a character vector of scale factors for each varibale.}
}
\value{
hessian matrix.
}
\description{
Computes the hessian matrix of functions, expressions and characters.
}
\section{Functions}{
\itemize{
\item \code{hessian}: arbitrary coordinate system

\item \code{\%hessian\%}: cartesian coordinates
}}

\examples{
# hessian with respect to x
hessian(f = "sin(x)", var = "x")
"sin(x)" \%hessian\% "x"

# hessian with respect to x and evaluate in x = 0
hessian(f = "sin(x)", var = c("x" = 0))
"sin(x)" \%hessian\% c(x=0)

# hessian with respect to (x,y)
hessian(f = "y*sin(x)", var = c("x","y"))
"y*sin(x)" \%hessian\% c("x","y")

# hessian in spherical coordinates
hessian('r*theta*phi', var = c('r','theta','phi'), coordinates = 'spherical')

# numerical hessian in spherical coordinates
f <- function(r, theta, phi) r*theta*phi
hessian(f, var = c('r'=1, 'theta'=pi/4, 'phi'=pi/4), coordinates = 'spherical')

}
