% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.cSEMResult.R
\name{plot.cSEMResults_2ndorder}
\alias{plot.cSEMResults_2ndorder}
\title{\code{cSEMResults} method for \code{plot()} for second-order models.}
\usage{
\method{plot}{cSEMResults_2ndorder}(
  x,
  .title = args_default()$.title,
  .plot_significances = args_default()$.plot_significances,
  .plot_correlations = args_default()$.plot_correlations,
  .plot_structural_model_only = args_default()$.plot_structural_model_only,
  .plot_labels = args_default()$.plot_labels,
  .graph_attrs = args_default()$.graph_attrs,
  ...
)
}
\arguments{
\item{x}{An R object of class \code{cSEMResults_2ndorder} object.}

\item{.title}{Character string. Title of an object. Defaults to \emph{""}.}

\item{.plot_significances}{Logical. Should p-values in the form of stars be plotted? Defaults to \code{TRUE}.}

\item{.plot_correlations}{Character string. Specify which correlations should be plotted, i.e.,
between the exogenous constructs (\code{exo}), between the exogenous constructs and the indicators (\code{all}),
or not at all (\code{none}). Defaults to \code{exo}.}

\item{.plot_structural_model_only}{Logical. Should only the structural model,
i.e., the constructs and their relationships be plotted? Defaults to \code{FALSE}.}

\item{.plot_labels}{Logical. Whether to display edge labels and node R² values. Defaults to TRUE.}

\item{.graph_attrs}{Character string. Additional attributes that should be passed
to the DiagrammeR syntax, e.g., c("rankdir=LR", "ranksep=1.0"). Defaults to \emph{c("rankdir=LR")}.}

\item{...}{Currently ignored.}
}
\description{
\lifecycle{experimental}
}
\details{
Creates a plot of a \code{cSEMResults_2ndorder} object using the \link[DiagrammeR]{grViz} function.
For more details on customizing plot, see \href{https://rpubs.com/nguyen_mot/1275413}{https://rpubs.com/nguyen_mot/1275413}.
}
\seealso{
\code{\link[=csem]{csem()}}, \link{cSEMResults}, \link[DiagrammeR]{grViz}
}
