% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_assess.R
\name{calculateHTMT}
\alias{calculateHTMT}
\title{HTMT}
\usage{
calculateHTMT(
 .object               = NULL,
 .type_htmt            = c('htmt','htmt2'),
 .absolute             = TRUE,
 .alpha                = 0.05,
 .ci                   = c("CI_percentile", "CI_standard_z", "CI_standard_t", 
                           "CI_basic", "CI_bc", "CI_bca", "CI_t_interval"),
 .inference            = FALSE,
 .only_common_factors  = TRUE,
 .R                    = 499,
 .seed                 = NULL,
 ...
)
}
\arguments{
\item{.object}{An R object of class \link{cSEMResults} resulting from a call to \code{\link[=csem]{csem()}}.}

\item{.type_htmt}{Character string indicating the type of HTMT that should be
calculated, i.e., the original HTMT ("\emph{htmt}") or the HTMT2 ("\emph{htmt2}").
Defaults to "\emph{htmt}"}

\item{.absolute}{Logical. Should the absolute HTMT values be returned?
Defaults to \code{TRUE} .}

\item{.alpha}{A numeric value giving the significance level.
Defaults to \code{0.05}.}

\item{.ci}{A character strings naming the type of confidence interval to use
to compute the 1-alpha\% quantile of the bootstrap HTMT values. For possible
choices see \code{\link[=infer]{infer()}}. Ignored
if \code{.inference = FALSE}. Defaults to "\emph{CI_percentile}".}

\item{.inference}{Logical. Should critical values be computed? Defaults to \code{FALSE}.}

\item{.only_common_factors}{Logical. Should only concepts modeled as common
factors be included when calculating one of the following quality criteria:
AVE, the Fornell-Larcker criterion, HTMT, and all reliability estimates.
Defaults to \code{TRUE}.}

\item{.R}{Integer. The number of bootstrap replications. Defaults to \code{499}.}

\item{.seed}{Integer or \code{NULL}. The random seed to use. Defaults to \code{NULL} in which
case an arbitrary seed is chosen. Note that the scope of the seed is limited
to the body of the function it is used in. Hence, the global seed will
not be altered!}

\item{...}{Ignored.}
}
\value{
A named list containing:
\itemize{
\item the values of the HTMT/HTMT2, i.e., a matrix with the HTMT/HTMT2 values
at its lower triangular and if \code{.inference = TRUE} the upper triangular contains
the upper limit of the 1-2*.alpha\% bootstrap confidence interval if the HTMT/HTMT2 is positive and
the lower limit if the HTMT/HTMT2 is negative.
\item the lower and upper limits of the 1-2*.alpha\% bootstrap confidence interval if
\code{.inference = TRUE}; otherwise it is \code{NULL}.
\item the number of admissible bootstrap runs, i.e., the number of HTMT/HTMT2 values
calculated during bootstrap if \code{.inference = TRUE}; otherwise it is \code{NULL}.
Note, the HTMT2 is based on the geometric and thus cannot always be calculated.
}
}
\description{
Computes either the heterotrait-monotrait ratio of correlations (HTMT) based on
\insertCite{Henseler2015;textual}{cSEM} or the HTMT2 proposed by \insertCite{Roemer2021;textual}{cSEM}.
While the HTMT is a consistent estimator for the construct correlation in
case of tau-equivalent measurement models, the HTMT2 is a consistent estimator
for congeneric measurement models. In general, they are used to assess discriminant validity.
}
\details{
Computation of the HTMT/HTMT2 assumes that all intra-block and inter-block
correlations between indicators are either all-positive or all-negative.
A warning is given if this is not the case.

To obtain bootstrap confidence intervals for the HTMT/HTMT2 values, set \code{.inference = TRUE}.
To choose the type of confidence interval, use \code{.ci}. To control the bootstrap process,
arguments \code{.R} and \code{.seed} are available. Note, that \code{.alpha} is multiplied by two
because typically researchers are interested in one-sided bootstrap confidence intervals
for the HTMT/HTMT2.

Since the HTMT and the HTMT2 both assume a reflective measurement
model only concepts modeled as common factors are considered by default.
For concepts modeled as composites the HTMT may be computed by setting
\code{.only_common_factors = FALSE}, however, it is unclear how to
interpret values in this case.
}
\references{
\insertAllCited{}
}
\seealso{
\code{\link[=assess]{assess()}}, \link{csem}, \link{cSEMResults}
}
