% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/postestimate_predict.R
\name{predict}
\alias{predict}
\title{Predict indicator scores}
\usage{
predict(
 .object               = NULL,
 .benchmark            = c("lm", "unit", "PLS-PM", "GSCA", "PCA", "MAXVAR"),
 .cv_folds             = 10,
 .handle_inadmissibles = c("stop", "ignore", "set_NA"),
 .r                    = 10,
 .test_data            = NULL
 )
}
\arguments{
\item{.object}{An R object of class \link{cSEMResults} resulting from a call to \code{\link[=csem]{csem()}}.}

\item{.benchmark}{Character string. The procedure to obtain benchmark predictions.
One of "\emph{lm}", "\emph{unit}", "\emph{PLS-PM}", "\emph{GSCA}", "\emph{PCA}", or "\emph{MAXVAR}".
Default to "\emph{lm}".}

\item{.cv_folds}{Integer. The number of cross-validation folds to use. Setting
\code{.cv_folds} to \code{N} (the number of observations) produces
leave-one-out cross-validation samples. Defaults to \code{10}.}

\item{.handle_inadmissibles}{Character string. How should inadmissible results
be treated? One of "\emph{stop}", "\emph{ignore}", or "\emph{set_NA}". If "\emph{stop}", \code{\link[=predict]{predict()}}
will stop immediatly if estimation yields an inadmissible result.
For "\emph{ignore}" all results are returned even if all or some of the estimates
yielded inadmissible results.
For "\emph{set_NA}" predictions based on inadmissible parameter estimates are
set to \code{NA}. Defaults to "\emph{stop}"}

\item{.r}{Integer. The number of repetitions to use. Defaults to \code{10}.}

\item{.test_data}{A matrix of test data with the same column names as the
training data.}
}
\value{
An object of class \code{cSEMPredict} with print and plot methods.
Technically, \code{cSEMPredict} is a
named list containing the following list elements:

\describe{
\item{\verb{$Actual}}{A matrix of the actual values/indicator scores of the endogenous constructs.}
\item{\verb{$Prediction_target}}{A matrix of the predicted indicator scores of the endogenous constructs
based on the target model. Target refers to procedure used to estimate
the parameters in \code{.object}.}
\item{\verb{$Residuals_target}}{A matrix of the residual indicator scores of the endogenous constructs
based on the target model.}
\item{\verb{$Residuals_benchmark}}{A matrix of the residual indicator scores
of the endogenous constructs based on a model estimated by the procedure
given to \code{.benchmark}.}
\item{\verb{$Prediction_metrics}}{A data frame containing the predictions metrics
MAE, RMSE, and Q2_predict.}
\item{\verb{$Information}}{A list with elements
\code{Target}, \code{Benchmark},
\code{Number_of_observations_training}, \code{Number_of_observations_test}, \code{Number_of_folds},
\code{Number_of_repetitions}, and \code{Handle_inadmissibles}.}
}
}
\description{
\lifecycle{maturing}
}
\details{
Predict the indicator scores of endogenous constructs.

Predict uses the procedure introduced by \insertCite{Shmueli2016;textual}{cSEM} in the context of
PLS (commonly called: "PLSPredict" \insertCite{Shmueli2019}{cSEM}).
Predict uses k-fold cross-validation to randomly
split the data into training and test data and subsequently predicts the
relevant values in the test data based on the model parameter estimates obtained
using the training data. The number of cross-validation folds is 10 by default but
may be changed using the \code{.cv_folds} argument.
By default, the procedure is repeated \code{.r = 10} times to avoid irregularities
due to a particular split. See \insertCite{Shmueli2019;textual}{cSEM} for
details.

Alternatively, users may supply a matrix or a data frame of \code{.test_data} with
the same column names as those in the data used to obtain \code{.object} (the training data).
In this case, arguments \code{.cv_folds} and \code{.r} are
ignored and predict uses the estimated coefficients from \code{.object} to
predict the values in the columns of \code{.test_data}.

In \insertCite{Shmueli2016;textual}{cSEM} PLS-based predictions for indicator \code{i}
are compared to the predictions based on a multiple regression of indicator \code{i}
on all available exogenous indicators (\code{.benchmark = "lm"}) and
a simple mean-based prediction summarized in the Q2_predict metric.
\code{predict()} is more general in that is allows users to compare the predictions
based on a so-called target model/specification to predictions based on an
alternative benchmark. Available benchmarks include predictions
based on a linear model, PLS-PM weights, unit weights (i.e. sum scores),
GSCA weights, PCA weights, and MAXVAR weights.

Each estimation run is checked for admissibility using \code{\link[=verify]{verify()}}. If the
estimation yields inadmissible results, \code{predict()} stops with an error (\code{"stop"}).
Users may choose to \code{"ignore"} inadmissible results or to simply set predictions
to \code{NA} (\code{"set_NA"}) for the particular run that failed.
}
\examples{
### Anime example taken from https://github.com/ISS-Analytics/pls-predict

# Load data
data(Anime) # data is similar to the Anime.csv found on 
            # https://github.com/ISS-Analytics/pls-predict but with irrelevant
            # columns removed

# Split into training and data the same way as it is done on 
# https://github.com/ISS-Analytics/pls-predict
set.seed(123)

index     <- sample.int(dim(Anime)[1], 83, replace = FALSE)
dat_train <- Anime[-index, ]
dat_test  <- Anime[index, ]

# Specify model
model <- "
# Structural model

ApproachAvoidance ~ PerceivedVisualComplexity + Arousal

# Measurement/composite model

ApproachAvoidance         =~ AA0 + AA1 + AA2 + AA3
PerceivedVisualComplexity <~ VX0 + VX1 + VX2 + VX3 + VX4
Arousal                   <~ Aro1 + Aro2 + Aro3 + Aro4
"

# Estimate (replicating the results of the `simplePLS()` function)
res <- csem(dat_train, 
            model, 
            .disattenuate = FALSE, # original PLS
            .iter_max = 300, 
            .tolerance = 1e-07, 
            .PLS_weight_scheme_inner = "factorial"
)

# Predict using a user-supplied training data set
pp <- predict(res, .test_data = dat_test)
pp$Predictions_target[1:6, ]
pp

### Compute prediction metrics  ------------------------------------------------
res2 <- csem(Anime, # whole data set
            model, 
            .disattenuate = FALSE, # original PLS
            .iter_max = 300, 
            .tolerance = 1e-07, 
            .PLS_weight_scheme_inner = "factorial"
)

# Predict using 10-fold cross-validation with 5 repetitions
\dontrun{
pp2 <- predict(res, .benchmark = "lm")
pp2
## There is a plot method available
plot(pp2)}

}
\references{
\insertAllCited{}
}
\seealso{
\link{csem}, \link{cSEMResults}, \code{\link[=exportToExcel]{exportToExcel()}}
}
