% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/postestimate_doSurfaceAnalysis.R
\name{doSurfaceAnalysis}
\alias{doSurfaceAnalysis}
\title{Do a surface analysis}
\usage{
doSurfaceAnalysis(
 .object             = NULL,
 .alpha              = 0.05,
 .dependent          = NULL, 
 .independent_1      = NULL,
 .independent_2      = NULL,
 .n_steps            = 100
 )
}
\arguments{
\item{.object}{An R object of class \link{cSEMResults} resulting from a call to \code{\link[=csem]{csem()}}.}

\item{.alpha}{An integer or a numeric vector of significance levels.
Defaults to \code{0.05}.}

\item{.dependent}{Character string. The name of the dependent variable. Defaults to \code{NULL}.}

\item{.independent_1}{Character string. The name of the first independent variable. Defaults to \code{NULL}.}

\item{.independent_2}{Character string. The name of the second independent variable. Defaults to \code{NULL}.}

\item{.n_steps}{Integer. A numeric value giving the number of steps, e.g., in
surface analysis or floodlight analysis the spotlights (= values of .moderator)
between min(.moderator) and max(.moderator) to use. Defaults to \code{100}.}
}
\value{
A list of class \code{cSEMSurface} with a corresponding method for \code{plot()}.
See: \code{\link[=plot.cSEMSurface]{plot.cSEMSurface()}}.
}
\description{
Based on a nonlinear model, the dependent variable of a certain equation is
predicted by two independent variable, i.e., .independent_1 and .independent_2
including their higher-order terms.
}
\seealso{
\code{\link[=csem]{csem()}}, \link{cSEMResults}, \code{\link[=plot.cSEMSurface]{plot.cSEMSurface()}}
}
