% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betaBinomial.R
\name{log_likelihood}
\alias{log_likelihood}
\title{Calculate the negative log-likelihood for a beta binomial regression model}
\usage{
log_likelihood(params, X, Z, y, weights)
}
\arguments{
\item{params}{A numeric vector containing all model parameters. The first n_beta elements
are coefficients for the mean model, and the remaining elements are
coefficients for the log-standard deviation model.}

\item{X}{A matrix of predictors for the mean model.}

\item{Z}{A matrix of predictors for the log-standard deviation model.}

\item{y}{A numeric vector of response values.}

\item{weights}{A numeric vector of weights for each observation.}
}
\value{
The negative log-likelihood of the model.
}
\description{
This function computes the negative log-likelihood for a beta binomial regression model
where both the mean and standard deviation are modeled as functions of predictors.
}
\keyword{internal}
