% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plotRaw}
\alias{plotRaw}
\title{Plot manifest and fitted raw scores}
\usage{
plotRaw(data, model, group = NULL, raw = NULL, type = 0)
}
\arguments{
\item{data}{The raw data within a data.frame or cnorm object}

\item{model}{The regression model (optional)}

\item{group}{The grouping variable}

\item{raw}{The raw score variable}

\item{type}{Type of display: 0 = plot manifest against fitted values, 1 = plot
manifest against difference values}
}
\description{
The function plots the raw data against the fitted scores from
the regression model per group. This helps to inspect the precision
of the modeling process. The scores should not deviate too far from
regression line.
}
\examples{
# Compute model with example dataset and plot results
result <- cnorm(raw = elfe$raw, group = elfe$group)
plotRaw(result)
}
\seealso{
Other plot: 
\code{\link{plot.cnorm}()},
\code{\link{plotDensity}()},
\code{\link{plotDerivative}()},
\code{\link{plotNormCurves}()},
\code{\link{plotNorm}()},
\code{\link{plotPercentileSeries}()},
\code{\link{plotPercentiles}()},
\code{\link{plotSubset}()}
}
\concept{plot}
