% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spillover.R, R/print-spillover.R
\name{dynamic_spillover}
\alias{dynamic_spillover}
\alias{print.bvhardynsp}
\alias{knit_print.bvhardynsp}
\alias{dynamic_spillover.olsmod}
\alias{dynamic_spillover.normaliw}
\alias{dynamic_spillover.ldltmod}
\alias{dynamic_spillover.svmod}
\title{Dynamic Spillover}
\usage{
dynamic_spillover(object, n_ahead = 10L, ...)

\method{print}{bvhardynsp}(x, digits = max(3L, getOption("digits") - 3L), ...)

\method{knit_print}{bvhardynsp}(x, ...)

\method{dynamic_spillover}{olsmod}(object, n_ahead = 10L, window, num_thread = 1, ...)

\method{dynamic_spillover}{normaliw}(
  object,
  n_ahead = 10L,
  window,
  num_iter = 1000L,
  num_burn = floor(num_iter/2),
  thinning = 1,
  num_thread = 1,
  ...
)

\method{dynamic_spillover}{ldltmod}(
  object,
  n_ahead = 10L,
  window,
  sparse = FALSE,
  num_thread = 1,
  ...
)

\method{dynamic_spillover}{svmod}(object, n_ahead = 10L, sparse = FALSE, num_thread = 1, ...)
}
\arguments{
\item{object}{Model object}

\item{n_ahead}{step to forecast. By default, 10.}

\item{...}{not used}

\item{x}{\code{bvhardynsp} object}

\item{digits}{digit option to print}

\item{window}{Window size}

\item{num_thread}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} Number of threads}

\item{num_iter}{Number to sample MNIW distribution}

\item{num_burn}{Number of burn-in}

\item{thinning}{Thinning every thinning-th iteration}

\item{sparse}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} Apply restriction. By default, \code{FALSE}.}
}
\description{
This function gives connectedness table with h-step ahead normalized spillover index (a.k.a. variance shares).
}
\references{
Diebold, F. X., & Yilmaz, K. (2012). \emph{Better to give than to receive: Predictive directional measurement of volatility spillovers}. International Journal of forecasting, 28(1), 57-66.
}
