% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rpart.R
\name{axe-rpart}
\alias{axe-rpart}
\alias{axe_call.rpart}
\alias{axe_ctrl.rpart}
\alias{axe_data.rpart}
\alias{axe_env.rpart}
\title{Axing a rpart.}
\usage{
\method{axe_call}{rpart}(x, verbose = FALSE, ...)

\method{axe_ctrl}{rpart}(x, verbose = FALSE, ...)

\method{axe_data}{rpart}(x, verbose = FALSE, ...)

\method{axe_env}{rpart}(x, verbose = FALSE, ...)
}
\arguments{
\item{x}{A model object.}

\item{verbose}{Print information each time an axe method is executed.
Notes how much memory is released and what functions are
disabled. Default is \code{FALSE}.}

\item{...}{Any additional arguments related to axing.}
}
\value{
Axed rpart object.
}
\description{
rpart objects are created from the \pkg{rpart} package, which
is used for recursive partitioning for classification, regression and
survival trees.
}
\examples{
# Load libraries
suppressWarnings(suppressMessages(library(parsnip)))
suppressWarnings(suppressMessages(library(rsample)))
suppressWarnings(suppressMessages(library(rpart)))
suppressWarnings(library(lobstr))

# Load data
set.seed(1234)
split <- initial_split(mtcars, props = 9/10)
car_train <- training(split)

# Create model and fit
rpart_fit <- decision_tree(mode = "regression") \%>\%
  set_engine("rpart") \%>\%
  fit(mpg ~ ., data = car_train, minsplit = 5, cp = 0.1)

out <- butcher(rpart_fit, verbose = TRUE)

# Another rpart object
wrapped_rpart <- function() {
  some_junk_in_environment <- runif(1e6)
  fit <- rpart(Kyphosis ~ Age + Number + Start,
               data = kyphosis,
               x = TRUE, y = TRUE)
  return(fit)
}

# Remove junk
cleaned_rpart <- axe_env(wrapped_rpart(), verbose = TRUE)

# Check size
lobstr::obj_size(cleaned_rpart)

}
