% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{count_event_position}
\alias{count_event_position}
\title{Count different events in an \code{fhx} object}
\usage{
count_event_position(
  x,
  injury_event = FALSE,
  position,
  drop_unknown = FALSE,
  groupby
)
}
\arguments{
\item{x}{An \code{fhx} object.}

\item{injury_event}{Optional boolean indicating whether injuries should be
considered an "event". Default is \code{FALSE}.}

\item{position}{Depreciated. This allowed users to specify which intra-ring
positions to include in the summary output table. The default counts all
types of event positions.}

\item{drop_unknown}{Boolean. Defaults to FALSE. If TRUE will remove the
"unknown_fs" and/or "unknown_fi" from rec_type.}

\item{groupby}{Optional named list containing character vectors that are used
to count the total number of different event types. The names given to each
character vector give the group's name in the output data frame.}
}
\value{
A data frame with a columns giving the event or event group and
values giving the corresponding count for each event type or group.
}
\description{
Count different events in an \code{fhx} object
}
\examples{
data(pgm)
count_event_position(pgm)

# As above, but considering injuries to be a type of event.
count_event_position(pgm, injury_event = TRUE)

# Often we only quantify known intra-ring positions.
# Remove the "unknown_fs" and/or "unknown_fi" with
count_event_position(pgm, drop_unknown = TRUE)

# Using custom "groupby" args in a named list, as
grplist <- list(
  foo = c("dormant_fs", "early_fs"),
  bar = c("middle_fs", "late_fs")
)
count_event_position(pgm, groupby = grplist)
# Note that if a position in the groupby list is
# not included in rec_type, forcats::fct_count()
# will throw a flag for an "Unknown levels in 'f':"

}
\seealso{
\itemize{
\item \code{\link[=get_event_years]{get_event_years()}} gets years for various events in an \code{fhx}
object. * \code{\link[=yearly_recording]{yearly_recording()}} count the number of "recording" events in
each year of an \code{fhx} object. * \code{\link[=series_stats]{series_stats()}} basic summary stats for an
\code{fhx} object.
}
}
