% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{count_event_position}
\alias{count_event_position}
\title{Count of different events}
\usage{
count_event_position(x, injury_event = FALSE, position, groupby)
}
\arguments{
\item{x}{An fhx object.}

\item{injury_event}{Optional boolean indicating whether injuries should be considered event. Default is FALSE.}

\item{position}{Optional character vector giving the types of event positions to include in the count. Can any combination of the following: "unknown", "dormant", "early", "middle", "late", "latewd". The default counts all event positions.}

\item{groupby}{Optional named list containing character vectors that are used to count the total number of different event types. The names given to each character vector give the group's name in the output data.frame.}
}
\value{
A data.frame with a columns giving the event and corresponding number of events for each event type.
}
\description{
Count of different events
}
\examples{
data(pgm)
count_event_position(pgm)

# As above, but considering injuries to be a type of event.
count_event_position(pgm, injury_event = TRUE)

# Count only events of a certain position, in this case, "unknown", "early", and "middle".
count_event_position(pgm, injury_event = TRUE, position = c("unknown", "early", "middle"))

# Using custom `groupby` args.
grplist <- list(foo = c("dormant_fs", "early_fs"), bar = c("middle_fs", "late_fs"))
count_event_position(pgm, groupby = grplist)

}
