% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intervals.R
\name{intervals}
\alias{intervals}
\title{Constructor for S3 intervals class.}
\usage{
intervals(comp, densfun = "weibull")
}
\arguments{
\item{comp}{A composite fhx instance. Should have only one series in it.}

\item{densfun}{String giving desired distribution to fit. Suggest "weibull" or "lognormal". Default is "weibull".}
}
\value{
An intervals instance.
}
\description{
Constructor for S3 intervals class.
}
\examples{
data(pgm)
interv <- intervals(composite(pgm))
print(interv)

mean(interv)  # Mean interval

# Now fit log-normal distribution instead of Weibull.
intervals(composite(pgm), densfun = "lognormal")

\dontrun{
# Boxplot of fire interval distribution.
boxplot(intervals(composite(pgm))$intervals)
}

}
