% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bundle_caret.R
\name{bundle.train}
\alias{bundle.train}
\alias{bundle_train}
\title{Bundle a caret \code{train} object}
\usage{
\method{bundle}{train}(x, ...)
}
\arguments{
\item{x}{A \link[caret:train]{train} object returned
from \code{\link[caret:train]{caret::train()}}.}

\item{...}{Not used in this bundler and included for compatibility with
the generic only. Additional arguments passed to this method will return
an error.}
}
\value{
A bundle object with subclass \code{bundled_train}.

Bundles are a list subclass with two components:

\item{object}{An R object. Gives the output of native serialization
methods from the model-supplying package, sometimes with additional
classes or attributes that aid portability. This is often
a \link[base:raw]{raw} object.}
\item{situate}{A function. The \code{situate()} function is defined when
\code{\link[=bundle]{bundle()}} is called, though is a loose analogue of an \code{\link[=unbundle]{unbundle()}} S3
method for that object. Since the function is defined on \code{\link[=bundle]{bundle()}}, it
has access to references and dependency information that can
be saved alongside the \code{object} component. Calling \code{\link[=unbundle]{unbundle()}} on a
bundled object \code{x} calls \code{x$situate(x$object)}, returning the
unserialized version of \code{object}. \code{situate()} will also restore needed
references, such as server instances and environmental variables.}

Bundles are R objects that represent a "standalone" version of their
analogous model object. Thus, bundles are ready for saving to a file; saving
with \code{\link[base:readRDS]{base::saveRDS()}} is our recommended serialization strategy for bundles,
unless documented otherwise for a specific method.

To restore the original model object \code{x} in a new environment, load its
bundle with \code{\link[base:readRDS]{base::readRDS()}} and run \code{\link[=unbundle]{unbundle()}} on it. The output
of \code{\link[=unbundle]{unbundle()}} is a model object that is ready to \code{\link[=predict]{predict()}} on new data,
and other restored functionality (like plotting or summarizing) is supported
as a side effect only.

The bundle package wraps native serialization methods from model-supplying
packages. Between versions, those model-supplying packages may change their
native serialization methods, possibly introducing problems with re-loading
objects serialized with previous package versions. The bundle package does
not provide checks for these sorts of changes, and ought to be used in
conjunction with tooling for managing and monitoring model environments
like \link[vetiver:vetiver-package]{vetiver} or \link[renv:renv-package]{renv}.

See \code{vignette("bundle")} for more information on bundling and its motivation.
}
\description{
Bundling a model prepares it to be saved to a file and later
restored for prediction in a new R session. See the 'Value' section for
more information on bundles and their usage.
}
\details{
Primarily, these methods call \code{\link[=bundle]{bundle()}} on the output of
\code{train_model_object$finalModel}. See the class of the output of that
slot for more details on the bundling method for that object.
}
\section{bundle and butcher}{

The \href{https://butcher.tidymodels.org/}{butcher} package allows you to remove
parts of a fitted model object that are not needed for prediction.

This bundle method is compatible with pre-butchering. That is, for a
fitted model \code{x}, you can safely call:

\if{html}{\out{<div class="sourceCode">}}\preformatted{res <-
  x \%>\%
  butcher() \%>\%
  bundle()
}\if{html}{\out{</div>}}

and predict with the output of \code{unbundle(res)} in a new R session.
}

\examples{
\dontshow{if (rlang::is_installed("caret") && identical(Sys.getenv("NOT_CRAN"), "true")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# fit model and bundle ------------------------------------------------
library(caret)

predictors <- mtcars[, c("cyl", "disp", "hp")]

set.seed(1)

mod <-
  train(
    x = predictors,
    y = mtcars$mpg,
    method = "glm"
  )

mod_bundle <- bundle(mod)

# then, after saveRDS + readRDS or passing to a new session ----------
mod_unbundled <- unbundle(mod_bundle)

mod_unbundled_preds <- predict(mod_unbundled, new_data = mtcars)
\dontshow{\}) # examplesIf}
}
\seealso{
Other bundlers: 
\code{\link{bundle.H2OAutoML}()},
\code{\link{bundle.keras.engine.training.Model}()},
\code{\link{bundle.luz_module_fitted}()},
\code{\link{bundle.model_fit}()},
\code{\link{bundle.model_stack}()},
\code{\link{bundle.recipe}()},
\code{\link{bundle.step_umap}()},
\code{\link{bundle.workflow}()},
\code{\link{bundle.xgb.Booster}()},
\code{\link{bundle}()}
}
\concept{bundlers}
