% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do_correction.R
\name{do_correction}
\alias{do_correction}
\title{Integration Constraint Correction}
\usage{
do_correction(zstar, binwidth, data_prepped, firstpass_results,
  correct_iter_max = 200, notch = FALSE, zD_bin = NA)
}
\arguments{
\item{zstar}{a numeric value for the the bunching point.}

\item{binwidth}{a numeric value for the width of each bin.}

\item{data_prepped}{(binned) data that includes all variables necessary for fitting the model.}

\item{firstpass_results}{initial bunching estimates without correction.}

\item{correct_iter_max}{maximum iterations for integration constraint correction. Default is 200.}

\item{notch}{whether analysis is for a kink or notch. Default is FALSE (kink).}

\item{zD_bin}{the bin marking the upper end of the dominated region (notch case).}
}
\value{
do_correction returns a list with the data and estimates after correcting for the integration constraint, as follows:
\item{data}{The dataset with the corrected counterfactual.}
\item{coefficients}{The coefficients of the model fit on the corrected data.}
\item{b_corrected}{The normalized excess mass, corrected for the integration constraint.}
\item{B_corrected}{The excess mass (not normalized), corrected for the integration constraint.}
\item{c0_corrected}{The counterfactual at zstar, corrected for the integration constraint.}
\item{marginal_buncher_corrected}{The location (z value) of the marginal buncher, corrected for the integration constraint.}
\item{alpha_corrected}{The estimated fraction of bunchers in the dominated region, corrected for the integration constraint (only in notch case).}
}
\description{
Implements the correction for the integration constraint.
}
\examples{
data(bunching_data)
binned_data <- bin_data(z_vector = bunching_data$kink, zstar = 10000,
                        binwidth = 50, bins_l = 20, bins_r = 20)
prepped_data <- prep_data_for_fit(binned_data, zstar = 10000, binwidth = 50,
                                  bins_l = 20, bins_r = 20, poly = 4)
firstpass <- fit_bunching(prepped_data$data_binned, prepped_data$model_formula)
corrected <- do_correction(zstar = 10000, binwidth = 50,
                           data_prepped = prepped_data$data_binned,
                           firstpass_results = firstpass)
paste0("Without correction, b = ", firstpass$b_estimate)
paste0("With correction, b = ", round(corrected$b_corrected,3))
}
\seealso{
\code{\link{bunchit}}, \code{\link{fit_bunching}}
}
