% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_dictionary.R
\name{generate_dictionary}
\alias{generate_dictionary}
\title{Create a data dictionary from labelled data}
\usage{
generate_dictionary(data)
}
\arguments{
\item{data}{a data frame or a survey object}
}
\value{
A tibble representing the data dictionary. Each row corresponds to a variable in the original
data frame, providing detailed information about the variable's characteristics.
}
\description{
\code{generate_dictionary()} creates a data dictionary from a specified data frame.
This function is particularly useful for understanding and documenting the
structure of your dataset, similar to data dictionaries in Stata or SPSS.
}
\details{
The function returns a tibble (a modern version of R's data frame) with the following columns:
\itemize{
\item \strong{position}: An integer vector indicating the column position in the data frame.
\item \strong{variable}: A character vector containing the names of the variables (columns).
\item \strong{description}: A character vector with a human-readable description of each variable.
\item \strong{column type}: A character vector specifying the data type (e.g., numeric, character) of each variable.
\item \strong{missing}: An integer vector indicating the count of missing values for each variable.
\item \strong{levels}: A list vector containing the levels for categorical variables, if applicable.
}
}
\examples{

# Creating a data dictionary from an SPSS file

file_path <- system.file("extdata", "Wages.sav", package = "bulkreadr")

wage_data <- read_spss_data(file = file_path)

generate_dictionary(wage_data)


}
