% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessExpressionMatrix.R
\name{preprocessExpressionMatrix}
\alias{preprocessExpressionMatrix}
\title{Pre-process the expression matrix before generating the shiny app}
\usage{
preprocessExpressionMatrix(
  expression.matrix,
  denoise = TRUE,
  output.plot = FALSE,
  normalisation.method = c("quantile", "rpm"),
  ...
)
}
\arguments{
\item{expression.matrix}{the expression matrix; rows correspond to genes and
columns correspond to samples}

\item{denoise}{whether to use noisyR to denoise the expression matrix;
proceeding without denoising data is not recommended}

\item{output.plot}{whether to create an expression-similarity plot for the
noise analysis (printed to the console); default is FALSE}

\item{normalisation.method}{the normalisation method to be used; default is
quantile; any unrecognised input will result in no normalisation being
applied, but proceeding with un-normalised data is not recommended}

\item{...}{optional arguments passed on to \code{noisyr::noisyr_counts()}}
}
\value{
The denoised, normalised expression matrix; some rows (genes)
may have been removed by noisyR.
}
\description{
This function denoises the expression matrix using the noisyR package
and then normalises it. It is recommended to use this function before using
\code{\link{generateShinyApp}}.
}
\examples{
expression.matrix <- as.matrix(read.csv(
  system.file("extdata", "expression_matrix.csv", package = "bulkAnalyseR"), 
  row.names = 1
))[1:500, 1:4]
expression.matrix.preproc <- preprocessExpressionMatrix(expression.matrix)
}
