% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildmer.R
\name{buildgam}
\alias{buildgam}
\title{Use \code{buildmer} to fit generalized additive models using \code{gam} from package \code{mgcv}}
\usage{
buildgam(formula, data = NULL, family = gaussian(), cl = NULL,
  direction = c("order", "backward"), crit = "LRT", include = NULL,
  calc.anova = FALSE, calc.summary = TRUE, ...)
}
\arguments{
\item{formula}{See the general documentation under \code{\link{buildmer-package}}}

\item{data}{See the general documentation under \code{\link{buildmer-package}}}

\item{family}{See the general documentation under \code{\link{buildmer-package}}}

\item{cl}{See the general documentation under \code{\link{buildmer-package}}}

\item{direction}{See the general documentation under \code{\link{buildmer-package}}}

\item{crit}{See the general documentation under \code{\link{buildmer-package}}}

\item{include}{See the general documentation under \code{\link{buildmer-package}}}

\item{calc.anova}{See the general documentation under \code{\link{buildmer-package}}}

\item{calc.summary}{See the general documentation under \code{\link{buildmer-package}}}

\item{...}{Additional options to be passed to \code{bam}}
}
\description{
Use \code{buildmer} to fit generalized additive models using \code{gam} from package \code{mgcv}
}
\examples{
\dontshow{
library(buildmer)
m <- buildgam(f1 ~ s(timepoint,bs='cr'),data=vowels)
}
\donttest{
library(buildmer)
m <- buildgam(f1 ~ s(timepoint,by=following) + s(participant,by=following,bs='re') +
                   s(participant,timepoint,by=following,bs='fs'),data=vowels)
}
}
\seealso{
\code{\link{buildmer-package}}
}
