% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_smoother.R
\name{sim_smoother}
\alias{sim_smoother}
\alias{sim_smoother.gaussian}
\alias{sim_smoother.nongaussian}
\title{Simulation Smoothing}
\usage{
sim_smoother(model, nsim, seed, use_antithetic = FALSE, ...)

\method{sim_smoother}{gaussian}(
  model,
  nsim = 1,
  seed = sample(.Machine$integer.max, size = 1),
  use_antithetic = FALSE,
  ...
)

\method{sim_smoother}{nongaussian}(
  model,
  nsim = 1,
  seed = sample(.Machine$integer.max, size = 1),
  use_antithetic = FALSE,
  ...
)
}
\arguments{
\item{model}{Model object.}

\item{nsim}{Number of independent samples.}

\item{seed}{Seed for the random number generator.}

\item{use_antithetic}{Use an antithetic variable for location. 
Default is \code{FALSE}. Ignored for multivariate models.}

\item{...}{Ignored.}
}
\value{
An array containing the generated samples.
}
\description{
Function \code{sim_smoother} performs simulation smoothing i.e. simulates the states
from the conditional distribution \eqn{p(\alpha | y, \theta)}.
}
\details{
For non-Gaussian/non-linear models, the simulation is based on the approximating
Gaussian model.
}
\examples{
model <- bsm_lg(rep(NA, 50), sd_level = uniform(1,0,5), sd_y = uniform(1,0,5))
sim <- sim_smoother(model, 12)
ts.plot(sim[, 1, ])
}
