% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expose_model_functions.R
\name{expose_model_functions.bgmfit}
\alias{expose_model_functions.bgmfit}
\alias{expose_model_functions}
\title{Expose user defined Stan function for post-processing}
\usage{
\method{expose_model_functions}{bgmfit}(
  model,
  scode = NULL,
  expose = TRUE,
  select_model = NULL,
  returnobj = TRUE,
  vectorize = FALSE,
  verbose = FALSE,
  envir = NULL,
  ...
)

expose_model_functions(model, ...)
}
\arguments{
\item{model}{An object of class \code{bgmfit}.}

\item{scode}{A character string (\code{Stan code}) containing the
user-defined Stan function(s). If \code{NULL} (default), the \code{scode}
is retrieved from the \code{model}.}

\item{expose}{A logical (default \code{TRUE}) to indicate whether to expose
functions and add them to the \code{model} as an attribute.}

\item{select_model}{A character string (default \code{NULL}) to indicate the
model name. This is for internal use only.}

\item{returnobj}{A logical (default \code{TRUE}) to indicate whether to
return the model object. When \code{expose = TRUE}, then it is advisable to
set \code{returnobj = TRUE} too.}

\item{vectorize}{A logical (default \code{FALSE}) to indicate whether the
exposed functions should be vectorized via \code{\link[base:Vectorize]{base::Vectorize()}}. Note that
currently \code{vectorize} should be set to \code{FALSE} because setting it
\code{TRUE} may not work as expected.}

\item{verbose}{An optional argument (logical, default \code{FALSE}) to
indicate whether to print information collected during setting up the
object(s).}

\item{envir}{Environment used for function evaluation. The default is
\code{NULL} which will set \code{parent.frame()} as default environment.
Note that since most of post processing functions are based on \pkg{brms},
the functions needed for evaluation should be in the \code{.GlobalEnv}.
Therefore, it is strongly recommended to set \code{ envir = globalenv()}
(or \code{envir = .GlobalEnv}). This is particularly true for the
derivatives such as velocity curve.}

\item{...}{Additional arguments passed to the
\code{\link[rstan:expose_stan_functions]{rstan::expose_stan_functions()}} function.}
}
\value{
An object of class \code{bgmfit} if \code{returnobj=TRUE}, otherwise
invisible \code{NULL}.
}
\description{
The \strong{expose_model_functions()} is a wrapper around the
\code{\link[rstan:expose_stan_functions]{rstan::expose_stan_functions()}} to expose user defined
\code{Stan} function(s). These exposed functions are needed during the
post-processing of the posterior draws.
}
\examples{

\donttest{
# Fit Bayesian SITAR model 

# To avoid mode estimation which takes time, the Bayesian SITAR model fit to 
# the 'berkeley_exdata' has been saved as an example fit ('berkeley_exfit').
# See 'bsitar' function for details on 'berkeley_exdata' and 'berkeley_exfit'.

# Check and confirm whether model fit object 'berkeley_exfit' exists
 berkeley_exfit <- getNsObject(berkeley_exfit)

model <- berkeley_exfit

# To save time, argument expose is set as FALSE which runs a dummy test 
# and avoid model compilation which often takes time

expose_model_functions(model, expose = FALSE)
}

}
\seealso{
\code{\link[rstan:expose_stan_functions]{rstan::expose_stan_functions()}}
}
\author{
Satpal Sandhu  \email{satpal.sandhu@bristol.ac.uk}
}
