% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_fit.R
\name{plot_fit}
\alias{plot_fit}
\title{Plot the 1-D time-series of estimated location and behavioural states}
\usage{
plot_fit(fit)
}
\arguments{
\item{fit}{an output object from \code{fit_ssm}}
}
\value{
Observed locations are plotted as filled circles and estimated locations as blue
lines with the 95\% credible interval as a ribbon. Uses \code{ggplot2} plotting functions.
}
\description{
Takes a fitted \code{fit_ssm} object and plots the observed (data), estimated 
location and behavioural states (posterior means) as 1-D time-series. Each
individual dataset is plotted separately.
}
\examples{
\dontrun{
data(ellie)
fit.s <- fitSSM(ellie, model = "DCRWS", tstep = 1, adapt = 2000, samples = 1000, 
              thin = 2, span = 0.1)
plot_fit(fit.s)

hfit.s <- fit_ssm(ellie, model = "hDCRWS", tstep = 1, adapt = 2000, samples = 1000, 
                thin = 2, span = 0.1)
plot_fit(hfit.s)
}
}

