% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bsam-package.R
\docType{package}
\name{bsam-package}
\alias{bsam}
\alias{bsam-package}
\title{Fit Bayesian state-space models to animal tracking data}
\description{
Models provided are DCRW (for location filtering), DCRWS (for
location filtering and behavioural state estimation), and their hierarchical 
versions (hDCRW, hDCRWS) to estimate parameters jointly across multiple 
individual tracking datasets. The models are fit in JAGS using Markov chain
Monte Carlo simulation methods. The models are intended to be fit to Argos
satellite tracking data but options exist to allow fits to other tracking
data types (type \code{?fit_ssm} for details).
}
\details{
\tabular{ll}{ Package: \tab bsam\cr Type: \tab Package\cr Version: \tab
1.0.0\cr Date: \tab 2016-06-14\cr License: \tab GPL-2\cr LazyLoad: \tab
yes\cr } Fit Bayesian state-space models to Argos satellite tracking data.
Models provided are DCRW - for location filtering; DCRWS - for location
filtering and behavioural state estimation with 2 behavioural states; hDCRW 
and hDCRWS - hierarchical models for location filtering only, and location 
filtering with behavioural state estimation, respectively, across multiple 
animals.

The hierarchical models may provide improved location and/or behavioural
state estimates compared to fitting DCRW/DCRWS to individual datasets.
}
\examples{
\dontrun{
# Fit DCRW model for state filtering and regularization
data(ellie)
fit <- fit_ssm(ellie, model = "DCRW", tstep = 1, adapt = 5000, samples = 5000, 
              thin = 5, span = 0.2)
diag_ssm(fit)
map_ssm(fit)
plot_fit(fit)
}
}
\author{
Ian Jonsen

Maintainer: Ian Jonsen <ian.jonsen@mq.edu.au>
}
\references{
Jonsen ID, Mills Flemming J, Myers RA (2005) Robust state-space modeling of
animal movement data. Ecology 86:2874-2880

Jonsen ID (2016) Joint estimation over multiple individuals improves behavioural 
state inference from animal movement data. Scientific Reports 6:20625
}
\seealso{
fit_ssm
}
\keyword{bsam}

