% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/useful-items.R
\name{descriptionBlock}
\alias{descriptionBlock}
\title{AdminLTE3 description block}
\usage{
descriptionBlock(
  number = NULL,
  number_color = NULL,
  number_icon = NULL,
  header = NULL,
  text = NULL,
  right_border = TRUE,
  margin_bottom = FALSE
)
}
\arguments{
\item{number}{Any number.}

\item{number_color}{Number color: see here for a list of valid colors \url{https://adminlte.io/themes/AdminLTE/pages/UI/general.html}.}

\item{number_icon}{Number icon, if any. Should be written like "fa fa-times".}

\item{header}{Bold text.}

\item{text}{Additional text.}

\item{right_border}{TRUE by default. Whether to display a right border to
separate two blocks. The last block on the right should not have a right border.}

\item{margin_bottom}{FALSE by default. Set it to TRUE when the
descriptionBlock is used in a \link{cardPad} context.}
}
\description{
Create a description block, perfect for writing statistics
}
\examples{
if (interactive()) {
 library(shiny)
 library(bs4Dash)
 shinyApp(
  ui = bs4DashPage(
    bs4DashNavbar(),
    bs4DashSidebar(),
    bs4DashControlbar(),
    bs4DashBody(
     bs4Card(
      solidHeader = FALSE,
      title = "Status summary",
      background = NULL,
      width = 4,
      status = "danger",
      footer = fluidRow(
        column(
          width = 6,
          descriptionBlock(
            number = "17\%", 
            number_color = "success", 
            number_icon = "fa fa-caret-up",
            header = "$35,210.43", 
            text = "TOTAL REVENUE", 
            right_border = TRUE,
            margin_bottom = FALSE
          )
        ),
        column(
          width = 6,
          descriptionBlock(
            number = "18\%", 
            number_color = "danger", 
            number_icon = "fa fa-caret-down",
            header = "1200", 
            text = "GOAL COMPLETION", 
            right_border = FALSE,
            margin_bottom = FALSE
          )
        )
      )
     )
    ),
    title = "Description Blocks"
  ),
  server = function(input, output) { }
 )
}

}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
