% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bruceR-stats_1_basic.R
\name{Corr}
\alias{Corr}
\title{Correlation analysis.}
\usage{
Corr(
  data,
  method = "pearson",
  p.adjust = "none",
  all.as.numeric = TRUE,
  digits = 2,
  file = NULL,
  plot = TRUE,
  plot.r.size = 4,
  plot.colors = NULL,
  plot.file = NULL,
  plot.width = 8,
  plot.height = 6,
  plot.dpi = 500
)
}
\arguments{
\item{data}{Data frame.}

\item{method}{\code{"pearson"} (default), \code{"spearman"}, or \code{"kendall"}.}

\item{p.adjust}{Adjustment of \emph{p} values for multiple tests:
\code{"none"}, \code{"fdr"}, \code{"holm"}, \code{"bonferroni"}, ...
For details, see \code{\link[stats:p.adjust]{stats::p.adjust()}}.}

\item{all.as.numeric}{\code{TRUE} (default) or \code{FALSE}.
Transform all variables into numeric (continuous).}

\item{digits}{Number of decimal places of output. Defaults to \code{2}.}

\item{file}{File name of MS Word (\code{.doc}).}

\item{plot}{\code{TRUE} (default) or \code{FALSE}. Plot the correlation matrix.}

\item{plot.r.size}{Font size of correlation text label. Defaults to \code{4}.}

\item{plot.colors}{Plot colors (character vector). Defaults to "RdBu" of the Color Brewer Palette.}

\item{plot.file}{\code{NULL} (default, plot in RStudio) or a file name (\code{"xxx.png"}).}

\item{plot.width}{Width (in "inch") of the saved plot. Defaults to \code{8}.}

\item{plot.height}{Height (in "inch") of the saved plot. Defaults to \code{6}.}

\item{plot.dpi}{DPI (dots per inch) of the saved plot. Defaults to \code{500}.}
}
\value{
Invisibly return a list with
(1) correlation results from
\code{\link[psych:corr.test]{psych::corr.test()}} and
(2) a \code{ggplot2} object if \code{plot=TRUE}.
}
\description{
Correlation analysis.
}
\examples{
Corr(airquality)
Corr(airquality, p.adjust="bonferroni",
     plot.colors=c("#b2182b", "white", "#2166ac"))

d = as.data.table(psych::bfi)
added(d, {
  gender = as.factor(gender)
  education = as.factor(education)
  E = .mean("E", 1:5, rev=c(1,2), range=1:6)
  A = .mean("A", 1:5, rev=1, range=1:6)
  C = .mean("C", 1:5, rev=c(4,5), range=1:6)
  N = .mean("N", 1:5, range=1:6)
  O = .mean("O", 1:5, rev=c(2,5), range=1:6)
})
Corr(d[, .(age, gender, education, E, A, C, N, O)])

}
\seealso{
\code{\link{Describe}}

\code{\link{cor_multilevel}}
}
