% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bruceR-stats_2_scale.R
\name{Alpha}
\alias{Alpha}
\title{Reliability analysis (Cronbach's \eqn{\alpha} and McDonald's \eqn{\omega}).}
\usage{
Alpha(data, var, items, vars = NULL, varrange = NULL, rev = NULL, digits = 3)
}
\arguments{
\item{data}{Data frame.}

\item{var}{\strong{[Option 1]}
The common part across the variables. e.g., \code{"RSES"}}

\item{items}{\strong{[Option 1]}
The unique part across the variables. e.g., \code{1:10}}

\item{vars}{\strong{[Option 2]}
A character vector specifying the variables. e.g., \code{c("X1", "X2", "X3", "X4", "X5")}}

\item{varrange}{\strong{[Option 3]}
A character string specifying the positions ("starting:stopping") of variables. e.g., \code{"A1:E5"}}

\item{rev}{[Optional] Variables that need to be reversed. It can be
(1) a character vector specifying the reverse-scoring variables (recommended), or
(2) a numeric vector specifying the item number of reverse-scoring variables (not recommended).}

\item{digits}{Number of decimal places of output. Defaults to \code{3}.}
}
\value{
A list of results obtained from
\code{\link[psych:alpha]{psych::alpha()}} and \code{\link[psych:omega]{psych::omega()}}.
}
\description{
An extension of \code{\link[psych:alpha]{psych::alpha()}} and \code{\link[psych:omega]{psych::omega()}},
reporting (1) scale statistics
(Cronbach's \eqn{\alpha} and McDonald's \eqn{\omega}) and
(2) item statistics
(item-rest correlation [i.e., corrected item-total correlation]
and Cronbach's \eqn{\alpha} if item deleted).

Three options to specify variables:
\enumerate{
  \item \strong{\code{var + items}}: common and unique parts of variable names (suggested).
  \item \strong{\code{vars}}: a character vector of variable names (suggested).
  \item \strong{\code{varrange}}: starting and stopping positions of variables (NOT suggested).
}
}
\examples{
# ?psych::bfi
data = psych::bfi
Alpha(data, "E", 1:5)   # "E1" & "E2" should be reversed
Alpha(data, "E", 1:5, rev=1:2)            # correct
Alpha(data, "E", 1:5, rev=cc("E1, E2"))   # also correct
Alpha(data, vars=cc("E1, E2, E3, E4, E5"), rev=cc("E1, E2"))
Alpha(data, varrange="E1:E5", rev=cc("E1, E2"))

# using dplyr::select()
data \%>\% select(E1, E2, E3, E4, E5) \%>\%
  Alpha(vars=names(.), rev=cc("E1, E2"))

}
\seealso{
\code{\link{MEAN}}, \code{\link{EFA}}, \code{\link{CFA}}
}
