% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phylomatic.R
\name{phylomatic}
\alias{phylomatic}
\title{Query Phylomatic for a phylogenetic tree.}
\usage{
phylomatic(taxa, taxnames = TRUE, get = "GET", informat = "newick",
  method = "phylomatic", storedtree = "R20120829", treeuri = NULL,
  taxaformat = "slashpath", outformat = "newick", clean = TRUE,
  db = "apg", mssgs = TRUE, ...)
}
\arguments{
\item{taxa}{Phylomatic format input of taxa names.}

\item{taxnames}{If \code{TRUE} (default), we get the family names for you to attach
to your species names to send to Phylomatic API. If \code{FALSE}, you have to
provide the strings in the right format.}

\item{get}{'GET' (default) or 'POST' format for submission to the website.}

\item{informat}{One of newick (default), nexml, or cdaordf. If using a stored tree,
informat should always be newick.}

\item{method}{One of phylomatic (default) or convert}

\item{storedtree}{One of R20120829 (Phylomatic tree R20120829 for plants),
smith2011 (Smith 2011, plants), binindaemonds2007 (Bininda-Emonds 2007,
mammals), or zanne2014 (Zanne et al. 2014, plants). Default: R20120829}

\item{treeuri}{URL for a phylogenetic tree in newick format.}

\item{taxaformat}{Only option is slashpath for now. Leave as is.}

\item{outformat}{One of newick, nexml, or fyt.}

\item{clean}{Return a clean tree or not. Default: \code{TRUE}}

\item{db}{One of "ncbi", "itis", or "apg". Default: apg}

\item{mssgs}{Print messages. Default: \code{TRUE}}

\item{...}{curl options passed on to \code{\link[crul]{HttpClient}}}
}
\value{
Newick formatted tree as \code{phylo} object or
nexml character string
}
\description{
Query Phylomatic for a phylogenetic tree.
}
\details{
Use the web interface at \url{http://phylodiversity.net/phylomatic/}
}
\examples{
\dontrun{
# Input taxonomic names
taxa <- c("Poa annua", "Phlox diffusa", "Helianthus annuus")
tree <- phylomatic(taxa=taxa, get = 'POST')
plot(tree, no.margin=TRUE)

# Genus names
taxa <- c("Poa", "Phlox", "Helianthus")
tree <- phylomatic(taxa=taxa, storedtree='R20120829', get='POST')
plot(tree, no.margin=TRUE)

# Lots of names
taxa <- c("Poa annua", "Collomia grandiflora", "Lilium lankongense", "Phlox diffusa",
"Iteadaphne caudata", "Gagea sarmentosa", "Helianthus annuus")
tree <- phylomatic(taxa=taxa, get = 'POST')
plot(tree, no.margin=TRUE)

# Don't clean - clean=TRUE is default
(tree <- phylomatic(taxa=taxa, clean = FALSE))
## with clean=FALSE, you can get non-splitting nodes, which you
## need to collpase before plotting
library('ape')
plot(collapse.singles(tree), no.margin=TRUE)

# Output NeXML format
taxa <- c("Gonocarpus leptothecus", "Gonocarpus leptothecus", "Lilium lankongense")
out <- phylomatic(taxa=taxa, get = 'POST', outformat = "nexml")
cat(out)

# Lots of names, note that when you have enough names (number depends on length of individual
# names, so there's no per se rule), you will get an error when using \\code{get='GET'},
# when that happens use \\code{get='POST'}
library("taxize")
spp <- names_list("species", 5000)
# phylomatic(taxa = spp, get = "GET")
(out <- phylomatic(taxa = spp, get = "POST"))
plot(out)

# Pass in a tree from a URL on the web
spp <- c("Abies_nordmanniana", "Abies_bornmuelleriana", "Abies_cilicica", "Abies_cephalonica",
"Abies_numidica", "Abies_pinsapo", "Abies_alba")
url <- "http://datadryad.org/bitstream/handle/10255/dryad.8791/final_tree.tre?sequence=1"
phylomatic(taxa=spp, treeuri=url)
}
}
