% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats-anova.R
\name{glance.anova}
\alias{glance.anova}
\title{Glance at a(n) anova object}
\usage{
\method{glance}{anova}(x, ...)
}
\arguments{
\item{x}{An \code{anova} object, such as those created by \code{\link[stats:anova]{stats::anova()}},
\code{\link[car:Anova]{car::Anova()}}, \code{\link[car:leveneTest]{car::leveneTest()}}, or \code{\link[car:linearHypothesis]{car::linearHypothesis()}}.}

\item{...}{Additional arguments. Not used. Needed to match generic
signature only. \strong{Cautionary note:} Misspelled arguments will be
absorbed in \code{...}, where they will be ignored. If the misspelled
argument has a default value, the default value will be used.
For example, if you pass \code{conf.lvel = 0.9}, all computation will
proceed using \code{conf.level = 0.95}. Two exceptions here are:
\itemize{
\item \code{tidy()} methods will warn when supplied an \code{exponentiate} argument if
it will be ignored.
\item \code{augment()} methods will warn when supplied a \code{newdata} argument if it
will be ignored.
}}
}
\description{
Glance accepts a model object and returns a \code{\link[tibble:tibble]{tibble::tibble()}}
with exactly one row of model summaries. The summaries are typically
goodness of fit measures, p-values for hypothesis tests on residuals,
or model convergence information.

Glance never returns information from the original call to the modeling
function. This includes the name of the modeling function or any
arguments passed to the modeling function.

Glance does not calculate summary measures. Rather, it farms out these
computations to appropriate methods and gathers the results together.
Sometimes a goodness of fit measure will be undefined. In these cases
the measure will be reported as \code{NA}.

Glance returns the same number of columns regardless of whether the
model matrix is rank-deficient or not. If so, entries in columns
that no longer have a well-defined value are filled in with an \code{NA}
of the appropriate type.
}
\note{
Note that the output of \code{glance.anova()} will vary depending on the initializing
anova call. In some cases, it will just return an empty data frame. In other
cases, \code{glance.anova()} may return columns that are also common to
\code{tidy.anova()}. This is partly to preserve backwards compatibility with early
versions of \code{broom}, but also because the underlying anova model yields
components that could reasonably be interpreted as goodness-of-fit summaries
too.
}
\examples{
\dontshow{if (FALSE) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

# fit models
a <- lm(mpg ~ wt + qsec + disp, mtcars)
b <- lm(mpg ~ wt + qsec, mtcars)

mod <- anova(a, b)

# summarize model fit with tidiers
tidy(mod)
glance(mod)

# car::linearHypothesis() example
library(car)
mod_lht <- linearHypothesis(a, "wt - disp")
tidy(mod_lht)
glance(mod_lht)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=glance]{glance()}}

Other anova tidiers: 
\code{\link{glance.aov}()},
\code{\link{tidy.TukeyHSD}()},
\code{\link{tidy.anova}()},
\code{\link{tidy.aov}()},
\code{\link{tidy.aovlist}()},
\code{\link{tidy.manova}()}
}
\concept{anova tidiers}
\value{
A \code{\link[tibble:tibble]{tibble::tibble()}} with exactly one row and columns:
  \item{deviance}{Deviance of the model.}
  \item{df.residual}{Residual degrees of freedom.}

}
