% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gam_tidiers.R
\name{gam_tidiers}
\alias{gam_tidiers}
\alias{tidy.gam}
\alias{tidy.Gam}
\alias{glance.gam}
\alias{glance.Gam}
\title{Tidying methods for a generalized additive model (gam)}
\usage{
\method{tidy}{gam}(x, parametric = FALSE, ...)

\method{tidy}{Gam}(x, ...)

\method{glance}{gam}(x, ...)

\method{glance}{Gam}(x, ...)
}
\arguments{
\item{x}{gam or Gam object}

\item{parametric}{logical. Return parametric coefficients (\code{TRUE}) or 
information about smooth terms (\code{FALSE})?}

\item{...}{extra arguments (not used)}
}
\value{
All tidying methods return a data.frame without rownames, whose
structure depends on the method chosen.

\code{tidy.gam} called on an object from the gam package,
or an object from the mgcv package with \code{parametric = FALSE}, returns the 
tidied output of the parametric ANOVA with one row for each term in the formula.
The columns match those in \link{anova_tidiers}. 
\code{tidy.gam} called on a gam object from the mgcv package with 
\code{parametric = TRUE} returns the fixed coefficients.

\code{glance.gam} returns a one-row data.frame with the columns
  \item{df}{Degrees of freedom used by the coefficients}
  \item{logLik}{the data's log-likelihood under the model}
  \item{AIC}{the Akaike Information Criterion}
  \item{BIC}{the Bayesian Information Criterion}
  \item{deviance}{deviance}
  \item{df.residual}{residual degrees of freedom}
}
\description{
These methods tidy the coefficients of a "gam" object (generalized additive
model) into a summary, augment the original data with information on the
fitted values and residuals, and construct a one-row glance of the model's
statistics.
}
\details{
The "augment" method is handled by \link{lm_tidiers}.
}
\examples{

if (require("gam", quietly = TRUE)) {
    data(kyphosis)
    g <- gam(Kyphosis ~ s(Age,4) + Number, family = binomial, data = kyphosis)
    tidy(g)
    augment(g)
    glance(g)
}

}
\seealso{
\link{lm_tidiers}, \link{anova_tidiers}
}
