% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_identify_variables.R
\name{model_identify_variables}
\alias{model_identify_variables}
\alias{model_identify_variables.default}
\alias{model_identify_variables.lavaan}
\alias{model_identify_variables.aov}
\alias{model_identify_variables.clm}
\alias{model_identify_variables.clmm}
\alias{model_identify_variables.gam}
\title{Identify for each coefficient of a model the corresponding variable}
\usage{
model_identify_variables(model)

\method{model_identify_variables}{default}(model)

\method{model_identify_variables}{lavaan}(model)

\method{model_identify_variables}{aov}(model)

\method{model_identify_variables}{clm}(model)

\method{model_identify_variables}{clmm}(model)

\method{model_identify_variables}{gam}(model)
}
\arguments{
\item{model}{a model object}
}
\value{
A tibble with four columns:
\itemize{
\item \code{term}: coefficients of the model
\item \code{variable}: the corresponding variable
\item \code{var_class}: class of the variable (cf. \code{\link[stats:checkMFClasses]{stats::.MFclass()}})
\item \code{var_type}: \code{"continuous"}, \code{"dichotomous"} (categorical variable with 2 levels),
\code{"categorical"} (categorical variable with 3 or more levels), \code{"intercept"}
or \code{"interaction"}
\item \code{var_nlevels}: number of original levels for categorical variables
}
}
\description{
It will also identify interaction terms and intercept(s).
}
\examples{
Titanic \%>\%
  dplyr::as_tibble() \%>\%
  dplyr::mutate(Survived = factor(Survived, c("No", "Yes"))) \%>\%
  glm(
    Survived ~ Class + Age * Sex,
    data = ., weights = .$n,
    family = binomial
  ) \%>\%
  model_identify_variables()

iris \%>\%
  lm(
    Sepal.Length ~ poly(Sepal.Width, 2) + Species,
    data = .,
    contrasts = list(Species = contr.sum)
  ) \%>\%
  model_identify_variables()
}
\seealso{
\code{\link[=tidy_identify_variables]{tidy_identify_variables()}}

Other model_helpers: 
\code{\link{model_compute_terms_contributions}()},
\code{\link{model_get_assign}()},
\code{\link{model_get_coefficients_type}()},
\code{\link{model_get_contrasts}()},
\code{\link{model_get_model_frame}()},
\code{\link{model_get_model_matrix}()},
\code{\link{model_get_model}()},
\code{\link{model_get_nlevels}()},
\code{\link{model_get_n}()},
\code{\link{model_get_offset}()},
\code{\link{model_get_response}()},
\code{\link{model_get_terms}()},
\code{\link{model_get_weights}()},
\code{\link{model_get_xlevels}()},
\code{\link{model_list_contrasts}()},
\code{\link{model_list_terms_levels}()},
\code{\link{model_list_variables}()}
}
\concept{model_helpers}
