% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_get_terms.R
\name{model_get_terms}
\alias{model_get_terms}
\alias{model_get_terms.default}
\alias{model_get_terms.brmsfit}
\alias{model_get_terms.glmmTMB}
\alias{model_get_terms.model_fit}
\alias{model_get_terms.betareg}
\alias{model_get_terms.cch}
\alias{model_get_terms.fixest}
\title{Get the terms of a model}
\usage{
model_get_terms(model)

\method{model_get_terms}{default}(model)

\method{model_get_terms}{brmsfit}(model)

\method{model_get_terms}{glmmTMB}(model)

\method{model_get_terms}{model_fit}(model)

\method{model_get_terms}{betareg}(model)

\method{model_get_terms}{betareg}(model)

\method{model_get_terms}{cch}(model)

\method{model_get_terms}{fixest}(model)
}
\arguments{
\item{model}{(a model object, e.g. \code{glm})\cr
A model object.}
}
\description{
Return the result of \code{\link[stats:terms]{stats::terms()}} applied to the model
or \code{NULL} if it is not possible to get terms from \code{model}.
}
\details{
For models fitted with \code{glmmTMB::glmmTMB()}, it will return a terms object
taking into account all components ("cond" and "zi"). For a more
restricted terms object, please refer to \code{glmmTMB::terms.glmmTMB()}.

For \code{fixest} models, return a term object combining main variables and
instrumental variables.
}
\examples{
lm(hp ~ mpg + factor(cyl), mtcars) |>
  model_get_terms()
}
\seealso{
\code{\link[stats:terms]{stats::terms()}}

Other model_helpers: 
\code{\link{model_compute_terms_contributions}()},
\code{\link{model_get_assign}()},
\code{\link{model_get_coefficients_type}()},
\code{\link{model_get_contrasts}()},
\code{\link{model_get_model}()},
\code{\link{model_get_model_frame}()},
\code{\link{model_get_model_matrix}()},
\code{\link{model_get_n}()},
\code{\link{model_get_nlevels}()},
\code{\link{model_get_offset}()},
\code{\link{model_get_pairwise_contrasts}()},
\code{\link{model_get_response}()},
\code{\link{model_get_response_variable}()},
\code{\link{model_get_weights}()},
\code{\link{model_get_xlevels}()},
\code{\link{model_identify_variables}()},
\code{\link{model_list_contrasts}()},
\code{\link{model_list_higher_order_variables}()},
\code{\link{model_list_terms_levels}()},
\code{\link{model_list_variables}()}
}
\concept{model_helpers}
