% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_plus_plus.R
\name{tidy_plus_plus}
\alias{tidy_plus_plus}
\title{Tidy a model and compute additional informations}
\usage{
tidy_plus_plus(
  model,
  tidy_fun = tidy_with_broom_or_parameters,
  conf.int = TRUE,
  exponentiate = FALSE,
  variable_labels = NULL,
  term_labels = NULL,
  interaction_sep = " * ",
  categorical_terms_pattern = "{level}",
  disambiguate_terms = TRUE,
  disambiguate_sep = ".",
  add_reference_rows = TRUE,
  no_reference_row = NULL,
  add_estimate_to_reference_rows = TRUE,
  add_header_rows = FALSE,
  show_single_row = NULL,
  add_n = TRUE,
  intercept = FALSE,
  include = everything(),
  keep_model = FALSE,
  quiet = FALSE,
  strict = FALSE,
  ...
)
}
\arguments{
\item{model}{a model to be attached/tidied}

\item{tidy_fun}{option to specify a custom tidier function}

\item{conf.int}{should confidence intervals be computed? (see \code{\link[broom:reexports]{broom::tidy()}})}

\item{exponentiate}{logical indicating whether or not to exponentiate the
coefficient estimates. This is typical for logistic, Poisson and Cox models,
but a bad idea if there is no log or logit link; defaults to \code{FALSE}.}

\item{variable_labels}{a named list or a named vector of custom variable labels}

\item{term_labels}{a named list or a named vector of custom term labels}

\item{interaction_sep}{separator for interaction terms}

\item{categorical_terms_pattern}{a \link[glue:glue]{glue pattern} for
labels of categorical terms with treatment or sum contrasts
(see \code{\link[=model_list_terms_levels]{model_list_terms_levels()}})}

\item{disambiguate_terms}{should terms be disambiguated with
\code{\link[=tidy_disambiguate_terms]{tidy_disambiguate_terms()}}? (default \code{TRUE})}

\item{disambiguate_sep}{separator for \code{\link[=tidy_disambiguate_terms]{tidy_disambiguate_terms()}}}

\item{add_reference_rows}{should reference rows be added?}

\item{no_reference_row}{variables (accepts \link[dplyr:select]{tidyselect} notation)
for those no reference row should be added, when \code{add_reference_rows = TRUE}}

\item{add_estimate_to_reference_rows}{should an estimate value be added to reference rows?}

\item{add_header_rows}{should header rows be added?}

\item{show_single_row}{variables that should be displayed
on a single row (accepts \link[dplyr:select]{tidyselect} notation), when
\code{add_header_rows} is \code{TRUE}}

\item{add_n}{should the number of observations be added?}

\item{intercept}{should the intercept(s) be included?}

\item{include}{variables to include. Accepts \link[dplyr:select]{tidyselect}
syntax. Use \code{-} to remove a variable. Default is \code{everything()}.
See also \code{\link[=all_continuous]{all_continuous()}}, \code{\link[=all_categorical]{all_categorical()}}, \code{\link[=all_dichotomous]{all_dichotomous()}}
and \code{\link[=all_interaction]{all_interaction()}}}

\item{keep_model}{should the model be kept as an attribute of the final result?}

\item{quiet}{logical argument whether broom.helpers should not return a message
when requested output cannot be generated. Default is FALSE}

\item{strict}{logical argument whether broom.helpers should return an error
when requested output cannot be generated. Default is FALSE}

\item{...}{other arguments passed to \code{tidy_fun()}}
}
\description{
This function will apply sequentially:
\itemize{
\item \code{\link[=tidy_and_attach]{tidy_and_attach()}}
\item \code{\link[=tidy_disambiguate_terms]{tidy_disambiguate_terms()}}
\item \code{\link[=tidy_identify_variables]{tidy_identify_variables()}}
\item \code{\link[=tidy_add_contrasts]{tidy_add_contrasts()}}
\item \code{\link[=tidy_add_reference_rows]{tidy_add_reference_rows()}}
\item \code{\link[=tidy_add_estimate_to_reference_rows]{tidy_add_estimate_to_reference_rows()}}
\item \code{\link[=tidy_add_variable_labels]{tidy_add_variable_labels()}}
\item \code{\link[=tidy_add_term_labels]{tidy_add_term_labels()}}
\item \code{\link[=tidy_add_header_rows]{tidy_add_header_rows()}}
\item \code{\link[=tidy_add_n]{tidy_add_n()}}
\item \code{\link[=tidy_remove_intercept]{tidy_remove_intercept()}}
\item \code{\link[=tidy_select_variables]{tidy_select_variables()}}
\item \code{\link[=tidy_add_coefficients_type]{tidy_add_coefficients_type()}}
\item \code{\link[=tidy_detach_model]{tidy_detach_model()}}
}
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
ex1 <- lm(Sepal.Length ~ Sepal.Width + Species, data = iris) \%>\%
  tidy_plus_plus()
ex1

df <- Titanic \%>\%
  dplyr::as_tibble() \%>\%
  dplyr::mutate(
    Survived = factor(Survived, c("No", "Yes"))
  ) \%>\%
  labelled::set_variable_labels(
    Class = "Passenger's class",
    Sex = "Gender"
  )
  ex2 <- glm(
    Survived ~ Class + Age * Sex,
    data = df, weights = df$n,
    family = binomial
  ) \%>\%
    tidy_plus_plus(
      exponentiate = TRUE,
      add_reference_rows = FALSE,
      categorical_terms_pattern = "{level} / {reference_level}",
      add_n = TRUE
    )
  ex2
if (.assert_package("gtsummary", boolean = TRUE)) {
  ex3 <-
    glm(
      response ~ poly(age, 3) + stage + grade * trt,
      na.omit(gtsummary::trial),
      family = binomial,
      contrasts = list(
        stage = contr.treatment(4, base = 3),
        grade = contr.sum
      )
    ) \%>\%
    tidy_plus_plus(
      exponentiate = TRUE,
      variable_labels = c(age = "Age (in years)"),
      add_header_rows = TRUE,
      show_single_row = all_dichotomous(),
      term_labels = c("poly(age, 3)3" = "Cubic age"),
      keep_model = TRUE
    )
  ex3
}
\dontshow{\}) # examplesIf}
}
\seealso{
Other tidy_helpers: 
\code{\link{tidy_add_coefficients_type}()},
\code{\link{tidy_add_contrasts}()},
\code{\link{tidy_add_estimate_to_reference_rows}()},
\code{\link{tidy_add_header_rows}()},
\code{\link{tidy_add_n}()},
\code{\link{tidy_add_reference_rows}()},
\code{\link{tidy_add_term_labels}()},
\code{\link{tidy_add_variable_labels}()},
\code{\link{tidy_attach_model}()},
\code{\link{tidy_disambiguate_terms}()},
\code{\link{tidy_identify_variables}()},
\code{\link{tidy_remove_intercept}()},
\code{\link{tidy_select_variables}()}
}
\concept{tidy_helpers}
