% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_add_header_rows.R
\name{tidy_add_header_rows}
\alias{tidy_add_header_rows}
\title{Add header rows variables with several terms}
\usage{
tidy_add_header_rows(
  x,
  show_single_row = NULL,
  model = tidy_get_model(x),
  quiet = FALSE,
  strict = FALSE
)
}
\arguments{
\item{x}{a tidy tibble}

\item{show_single_row}{a vector indicating the names of binary
variables that should be displayed on a single row}

\item{model}{the corresponding model, if not attached to \code{x}}

\item{quiet}{logical argument whether broom.helpers should return an error
when requested output cannot be generated. Default is FALSE}

\item{strict}{logical argument whether broom.helpers should return an error
when requested output cannot be generated. Default is FALSE}
}
\description{
For variables with several terms (usually categorical variables but
could also be the case of continuous variables with polynomial terms
or splines), \code{tidy_add_header_rows()} will add an additional row
per variable, where \code{label} will be equal to \code{var_label}.
These additional rows could be identified with \code{header_row} column.
}
\details{
The \code{show_single_row} argument allows to specify a list
of dichotomous variables that should be displayed on a single row
instead of two rows.

The added \code{header_row} column will be equal to:
\itemize{
\item \code{TRUE} for an header row;
\item \code{FALSE} for a normal row of a variable with an header row;
\item \code{NA} for variables without an header row.
}

If the \code{label} column is not yet available in \code{x},
\code{\link[=tidy_add_term_labels]{tidy_add_term_labels()}} will be automatically applied.
}
\examples{
df <- Titanic \%>\%
  dplyr::as_tibble() \%>\%
  dplyr::mutate(Survived = factor(Survived, c("No", "Yes")))

df \%>\%
  glm(
    Survived ~ Class + Age + Sex,
    data = ., weights = .$n, family = binomial,
    contrasts = list(Age = contr.sum, Class = "contr.SAS")
  ) \%>\%
  tidy_and_attach() \%>\%
  tidy_add_variable_labels(labels = list(Class = "Custom label for Class")) \%>\%
  tidy_add_reference_rows() \%>\%
  tidy_add_header_rows()

if (requireNamespace("gtsummary")) {
  glm(
    response ~ stage + grade * trt,
    gtsummary::trial,
    family = binomial,
    contrasts = list(
      stage = contr.treatment(4, base = 3),
      grade = contr.treatment(3, base = 2),
      trt = contr.treatment(2, base = 2)
    )
  ) \%>\%
    tidy_and_attach() \%>\%
    tidy_add_reference_rows() \%>\%
    tidy_add_header_rows()
}
}
\seealso{
Other tidy_helpers: 
\code{\link{tidy_add_contrasts}()},
\code{\link{tidy_add_estimate_to_reference_rows}()},
\code{\link{tidy_add_reference_rows}()},
\code{\link{tidy_add_term_labels}()},
\code{\link{tidy_add_variable_labels}()},
\code{\link{tidy_attach_model}()},
\code{\link{tidy_identify_variables}()},
\code{\link{tidy_plus_plus}()},
\code{\link{tidy_remove_intercept}()}
}
\concept{tidy_helpers}
