% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmvn.R
\name{rmvn}
\alias{rmvn}
\title{Simulate multivariate normal}
\usage{
rmvn(n, mu = 0, V = matrix(1))
}
\arguments{
\item{n}{Number of simulation replicates.}

\item{mu}{Mean vector.}

\item{V}{Variance-covariance matrix.}
}
\value{
A matrix of size n x \code{length(mu)}.  Each row corresponds to a
  separate replicate.
}
\description{
Simulate from a multivariate normal distribution.
}
\details{
Uses the Cholesky decomposition of the matrix \code{V}, obtained by
  \code{\link[base]{chol}}.
}
\examples{
x <- rmvn(100, c(1,2),matrix(c(1,1,1,4),ncol=2))

}
\seealso{
\code{\link[stats]{rnorm}}
}
\keyword{datagen}

