% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prediction.R
\name{prediction}
\alias{prediction}
\title{Marginal Posterior Predictions from a 'brms' Model}
\usage{
prediction(
  object,
  data,
  summarize = TRUE,
  posterior = FALSE,
  index,
  dpar = NULL,
  resample = 0L,
  resampleseed = FALSE,
  effects = c("fixedonly", "includeRE", "integrateoutRE"),
  backtrans = c("response", "linear", "identity", "invlogit", "exp", "square"),
  k = 100L,
  ...
)
}
\arguments{
\item{object}{A fitted brms model object. Required.}

\item{data}{A data frame or data table passed to \code{fitted()}
as the new data to be used for predictions. Required.}

\item{summarize}{A logical value, whether or not to
calculate summaries of the posterior predictions.
Defaults to \code{TRUE}.}

\item{posterior}{A logical value whether or not to
save and return the posterior samples. Defaults
to \code{FALSE} as the assumption is a typical
use case is to return the summaries only.}

\item{index}{An optional integer vector, giving the posterior draws
to be used in the calculations. If omitted, defaults to all
posterior draws.}

\item{dpar}{Parameter passed on the \code{dpar}
argument of \code{fitted()} in brms. Defaults to \code{NULL}
indicating the mean or location parameter typically.}

\item{resample}{An integer indicating the number of
bootstrap resamples of the posterior predictions to
use when calculating summaries. Defaults to \code{0L}.
See documentation from \code{\link[=.averagePosterior]{.averagePosterior()}} for more details.}

\item{resampleseed}{A seed for random number generation. Defaults to \code{FALSE},
which means no seed is set.
Only used if \code{resample} is a positive, non-zero integer.
See documentation from \code{\link[=.averagePosterior]{.averagePosterior()}} for more details.}

\item{effects}{A character string indicating the type of
prediction to be made. Can be one of
\dQuote{fixedonly} meaning only use fixed effects,
\dQuote{includeRE} meaning that random effects should be
included in the predictions, or
\dQuote{integrateoutRE} meaning that random effects should be
integrated out / over in the predictions.}

\item{backtrans}{A character string indicating the type of
back transformation to be applied. Can be one of
\dQuote{response} meaning to use the response scale,
\dQuote{linear} or \dQuote{identity} meaning to use the linear predictor scale,
or a specific back transformation desired, from a possible list of
\dQuote{invlogit}, \dQuote{exp}, or \dQuote{square}.
Custom back transformations should only be needed if, for example,
the outcome variable was transformed prior to fitting the model.}

\item{k}{An integer providing the number of random draws to use for
integrating out the random effects. Only relevant when \code{effects}
is \dQuote{integrateoutRE}.}

\item{...}{Additional arguments passed to \code{fitted()}}
}
\value{
A list with \code{Summary} and \code{Posterior}.
Some of these may be \code{NULL} depending on the arguments used.
}
\description{
Calculate marginal predictions from a \code{brms} model.
Marginal predictions average over the input data for each posterior draw.
Marginal predictions for models with random effects will integrate
over random effects.
}
\references{
Pavlou, M., Ambler, G., Seaman, S., & Omar, R. Z. (2015)
\doi{10.1186/s12874-015-0046-6}
\dQuote{A note on obtaining correct marginal predictions from a random intercepts model for binary outcomes}
and
Skrondal, A., & Rabe-Hesketh, S. (2009)
\doi{10.1111/j.1467-985X.2009.00587.x}
\dQuote{Prediction in multilevel generalized linear models}
}
