% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\docType{class}
\name{brmsfit-class}
\alias{brmsfit-class}
\alias{brmsfit}
\title{Class \code{brmsfit} of models fitted with the \pkg{brms} package}
\description{
Models fitted with the \code{\link[brms:brms]{brms}} package are 
represented as a \code{brmsfit} object, which contains the posterior 
samples, model formula, Stan code, relevant data, and other information.
}
\details{
See \code{methods(class = "brmsfit")} for an overview of available methods.
}
\section{Slots}{

\describe{
\item{\code{formula}}{A \code{\link{brmsformula}} object}

\item{\code{family}}{A \code{\link{brmsfamily}} object}

\item{\code{data}}{A \code{data.frame} containing all variables used in the model}

\item{\code{data.name}}{The name of \code{data} as specified by the user}

\item{\code{model}}{The model code in \pkg{Stan} language}

\item{\code{prior}}{A \code{\link{brmsprior}} object containing
information on the priors used in the model}

\item{\code{autocor}}{An \code{\link{cor_brms}} object containing 
the autocorrelation structure if specified}

\item{\code{ranef}}{A \code{data.frame} containing the group-level structure}

\item{\code{cov_ranef}}{A \code{list} of customized group-level covariance matrices}

\item{\code{stanvars}}{A \code{\link{stanvars}} object or \code{NULL}}

\item{\code{stan_funs}}{A character string of length one or \code{NULL}}

\item{\code{loo}}{An empty slot for adding the \code{\link{loo}} 
criterion after model fitting}

\item{\code{waic}}{An empty slot for adding the \code{\link{waic}} 
criterion after model fitting}

\item{\code{kfold}}{An empty slot for adding the \code{\link{kfold}} 
criterion after model fitting}

\item{\code{R2}}{An empty slot for adding the \code{\link{bayes_R2}}
(Bayesian R-squared) value after model fitting}

\item{\code{marglik}}{An empty slot for adding a \code{bridge} object 
after model fitting containing the log marginal likelihood 
(see \code{\link{bridge_sampler}} for details)}

\item{\code{fit}}{An object of class \code{\link[rstan:stanfit]{stanfit}}
among others containing the posterior samples}

\item{\code{exclude}}{The names of the parameters for which samples are not saved}

\item{\code{algorithm}}{The name of the algorithm used to fit the model}

\item{\code{version}}{The versions of \pkg{brms} and \pkg{rstan} with 
which the model was fitted}

\item{\code{file}}{Optional name of a file in which the model object was stored in
or loaded from}
}}

\seealso{
\code{\link{brms}}, 
  \code{\link{brm}}, 
  \code{\link{brmsformula}}, 
  \code{\link{brmsfamily}}
}
