% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/loo-helpers.R
\name{reloo}
\alias{reloo}
\alias{reloo.loo}
\title{Compute exact cross-validation for problematic observations}
\usage{
reloo(x, ...)

\method{reloo}{loo}(x, fit, k_threshold = 0.7, check = TRUE, ...)
}
\arguments{
\item{x}{An \R object typically of class \code{loo}.}

\item{...}{Further arguments passed to 
\code{\link[brms:update.brmsfit]{update.brmsfit}} such
as \code{iter}, \code{chains}, or \code{cores}.}

\item{fit}{An \R object typically of class \code{brmsfit}.}

\item{k_threshold}{The threshold at which pareto \eqn{k} 
estimates are treated as problematic. Defaults to \code{0.7}. 
See \code{\link[loo:pareto_k_ids]{pareto_k_ids}}
for more details.}

\item{check}{Logical; If \code{TRUE} (the default), a crude 
check is performed if the \code{loo} object was generated
from the \code{brmsfit} object passed to argument \code{fit}.}
}
\value{
An object of the class as \code{x}.
}
\description{
Compute exact cross-validation for problematic observations
for which approximate leave-one-out cross-validation may
return incorrect results.
}
\details{
Warnings about Pareto \eqn{k} estimates indicate observations
for which the approximation to LOO is problematic (this is described in
detail in Vehtari, Gelman, and Gabry (2017) and the 
\pkg{\link[loo:loo-package]{loo}} package documentation).
If there are \eqn{J} observations with \eqn{k} estimates above
\code{k_threshold}, then \code{reloo} will refit the original model 
\eqn{J} times, each time leaving out one of the \eqn{J} 
problematic observations. The pointwise contributions of these observations
to the total ELPD are then computed directly and substituted for the
previous estimates from these \eqn{J} observations that are stored in the
original \code{loo} object.
}
\examples{
\dontrun{
fit1 <- brm(count ~ log_Age_c + log_Base4_c * Trt + (1|patient),
           data = epilepsy, family = poisson())
# throws warning about some pareto k estimates being too high
(loo1 <- loo(fit1))
(loo1 <- reloo(loo1, fit1))
}

}
\seealso{
\code{\link[brms:loo]{loo}}, \code{\link[brms:kfold]{kfold}}
}
