% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/priors.R
\name{get_prior}
\alias{get_prior}
\title{Overview on Priors for \pkg{brms} Models}
\usage{
get_prior(formula, data = NULL, family = gaussian(), autocor = NULL,
  nonlinear = NULL, partial = NULL, threshold = c("flexible",
  "equidistant"), internal = FALSE)
}
\arguments{
\item{formula}{An object of class 
\code{\link[brms:brmsformula]{brmsformula}}
(or one that can be coerced to that class): 
a symbolic description of the model to be fitted. 
The details of model specification are explained in 
\code{\link[brms:brmsformula]{brmsformula}}.}

\item{data}{An optional data frame, list or environment  (or object coercible by 
\code{as.data.frame} to a data frame) containing the variables in the model. 
If not found in data, the variables are taken from \code{environment(formula)}, 
typically the environment from which \code{brm} is called. 
Although it is optional, we strongly recommend to supply a data.frame.}

\item{family}{A description of the response distribution and link function 
to be used in the model. This can be a family function, 
a call to a family function or a character string naming the family.
Every family function has a \code{link} argument allowing to specify
the link function to be applied on the response variable.
If not specified, default links are used.
For details of supported families see 
\code{\link[brms:brmsfamily]{brmsfamily}}.}

\item{autocor}{An optional \code{\link{cor_brms}} object describing 
the correlation structure 
within the response variable (i.e. the 'autocorrelation'). 
See the documentation of \code{\link{cor_brms}} for a description 
of the available correlation structures. Defaults to NULL, 
corresponding to no correlations.}

\item{nonlinear}{An optional list of formuluas, specifying 
linear models for non-linear parameters. If \code{NULL} (the default)
\code{formula} is treated as an ordinary formula. 
If not \code{NULL}, \code{formula} is treated as a non-linear model
and \code{nonlinear} should contain a formula for each non-linear 
parameter, which has the parameter on the left hand side and its
linear predictor on the right hand side.
Alternatively, it can be a single formula with all non-linear
parameters on the left hand side (separated by a \code{+}) and a
common linear predictor on the right hand side.
More information is given under 'Details'.}

\item{partial}{(Deprecated) A one sided formula of the form 
\code{~expression} allowing to specify predictors with 
category specific effects in non-cumulative ordinal models 
(i.e. in families \code{cratio}, \code{sratio}, or \code{acat}).
As of \pkg{brms} > 0.8.0 category specific effects should be 
specified directly within \code{formula} using function \code{cse}.}

\item{threshold}{A character string indicating the type of thresholds 
(i.e. intercepts) used in an ordinal model. 
\code{"flexible"} provides the standard unstructured thresholds and 
\code{"equidistant"} restricts the distance between 
consecutive thresholds to the same value.}

\item{internal}{A flag indicating if the names of additional internal parameters should be displayed. 
Setting priors on these parameters is not recommended}
}
\value{
A data.frame with columns \code{prior}, \code{class}, \code{coef}, and \code{group}
  and several rows, each providing information on a parameter (or parameter class) on which
  priors can be specified. The prior column is empty except for internal default priors.
}
\description{
Get information on all parameters (and parameter classes) for which priors 
may be specified including default priors.
}
\examples{
## get all parameters and parameters classes to define priors on
(prior <- get_prior(count ~ log_Age_c + log_Base4_c * Trt_c
                    + (1|patient) + (1|visit),
                    data = epilepsy, family = poisson()))   
         
## define a prior on all population-level effects a once
prior$prior[1] <- "normal(0,10)"

## define a specific prior on the population-level effect of Trt_c
prior$prior[5] <- "student_t(10, 0, 5)"       

## verify that the priors indeed found their way into Stan's model code
make_stancode(count ~ log_Age_c + log_Base4_c * Trt_c 
              + (1|patient) + (1|visit),
              data = epilepsy, family = poisson(), 
              prior = prior)

}
\seealso{
\code{\link[brms:set_prior]{set_prior}}
}

