% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brm_formula.R
\name{brm_formula}
\alias{brm_formula}
\title{Model formula}
\usage{
brm_formula(
  data,
  intercept = TRUE,
  baseline = !is.null(attr(data, "brm_baseline")),
  baseline_subgroup = !is.null(attr(data, "brm_baseline")) && !is.null(attr(data,
    "brm_subgroup")),
  baseline_subgroup_time = !is.null(attr(data, "brm_baseline")) && !is.null(attr(data,
    "brm_subgroup")),
  baseline_time = !is.null(attr(data, "brm_baseline")),
  group = TRUE,
  group_subgroup = !is.null(attr(data, "brm_subgroup")),
  group_subgroup_time = !is.null(attr(data, "brm_subgroup")),
  group_time = TRUE,
  subgroup = !is.null(attr(data, "brm_subgroup")),
  subgroup_time = !is.null(attr(data, "brm_subgroup")),
  time = TRUE,
  correlation = "unstructured",
  effect_baseline = NULL,
  effect_group = NULL,
  effect_time = NULL,
  interaction_baseline = NULL,
  interaction_group = NULL
)
}
\arguments{
\item{data}{A classed data frame from \code{\link[=brm_data]{brm_data()}}.}

\item{intercept}{Logical of length 1.
\code{TRUE} (default) to include an intercept, \code{FALSE} to omit.}

\item{baseline}{Logical of length 1.
\code{TRUE} to include an additive effect for baseline
response, \code{FALSE} to omit.
Default is \code{TRUE} if \code{\link[=brm_data]{brm_data()}} previously declared a baseline
variable in the dataset.}

\item{baseline_subgroup}{Logical of length 1.
\code{TRUE} to include baseline-by-subgroup interaction, \code{FALSE} to omit.
Default is \code{TRUE} if \code{\link[=brm_data]{brm_data()}} previously declared baseline
and subgroup variables in the dataset.}

\item{baseline_subgroup_time}{Logical of length 1.
\code{TRUE} to include baseline-by-subgroup-by-time interaction,
\code{FALSE} to omit.
Default is \code{TRUE} if \code{\link[=brm_data]{brm_data()}} previously declared baseline
and subgroup variables in the dataset.}

\item{baseline_time}{Logical of length 1.
\code{TRUE} to include baseline-by-time interaction, \code{FALSE} to omit.
Default is \code{TRUE} if \code{\link[=brm_data]{brm_data()}} previously declared a baseline
variable in the dataset.}

\item{group}{Logical of length 1.
\code{TRUE} (default) to include additive effects for
treatment groups, \code{FALSE} to omit.}

\item{group_subgroup}{Logical of length 1.
\code{TRUE} to include group-by-subgroup interaction, \code{FALSE} to omit.
Default is \code{TRUE} if \code{\link[=brm_data]{brm_data()}} previously declared a subgroup
variable in the dataset.}

\item{group_subgroup_time}{Logical of length 1.
\code{TRUE} to include group-by-subgroup-by-time interaction, \code{FALSE} to omit.
Default is \code{TRUE} if \code{\link[=brm_data]{brm_data()}} previously declared a subgroup
variable in the dataset.}

\item{group_time}{Logical of length 1.
\code{TRUE} (default) to include group-by-time interaction, \code{FALSE} to omit.}

\item{subgroup}{Logical of length 1.
\code{TRUE} to include additive fixed effects for subgroup levels,
\code{FALSE} to omit.
Default is \code{TRUE} if \code{\link[=brm_data]{brm_data()}} previously declared a subgroup
variable in the dataset.}

\item{subgroup_time}{Logical of length 1.
\code{TRUE} to include subgroup-by-time interaction, \code{FALSE} to omit.
Default is \code{TRUE} if \code{\link[=brm_data]{brm_data()}} previously declared a subgroup
variable in the dataset.}

\item{time}{Logical of length 1.
\code{TRUE} (default) to include a additive effect for discrete time,
\code{FALSE} to omit.}

\item{correlation}{Character of length 1, name of the correlation
structure. Only \code{"unstructured"} is currently supported.}

\item{effect_baseline}{Deprecated on 2024-01-16 (version 0.0.2.9002).
Use \code{baseline} instead.}

\item{effect_group}{Deprecated on 2024-01-16 (version 0.0.2.9002).
Use \code{group} instead.}

\item{effect_time}{Deprecated on 2024-01-16 (version 0.0.2.9002).
Use \code{time} instead.}

\item{interaction_baseline}{Deprecated on 2024-01-16 (version 0.0.2.9002).
Use \code{baseline_time} instead.}

\item{interaction_group}{Deprecated on 2024-01-16 (version 0.0.2.9002).
Use \code{group_time} instead.}
}
\value{
An object of class \code{"brmsformula"} returned from
\code{brms::brmsformula()}. It contains the fixed effect parameterization,
correlation structure, and residual variance structure.
}
\description{
Build a model formula for an MMRM.
}
\details{
\code{\link[=brm_formula]{brm_formula()}} builds an R formula for an MMRM based on
the details in the data and your choice of parameterization.
Customize your parameterization by toggling on or off
the various \code{TRUE}/\code{FALSE} arguments of \code{\link[=brm_formula]{brm_formula()}},
such as \code{intercept}, \code{baseline}, and \code{group_time}.
All plausible additive effects, two-way interactions, and
three-way interactions can be specified. The following interactions
are not supported:
\itemize{
\item Any interactions with the concomitant covariates you specified in the
\code{covariates} argument of \code{\link[=brm_data]{brm_data()}}.
\item Any interactions which include baseline response and treatment
group together. Rationale: in a randomized controlled experiment,
baseline and treatment group assignment should be uncorrelated.
}
}
\section{Parameterization}{

The formula is not the only factor
that determines the fixed effect parameterization.
The ordering of the categorical variables in the data,
as well as the \code{contrast} option in R, affect the
construction of the model matrix. To see the model
matrix that will ultimately be used in \code{\link[=brm_model]{brm_model()}},
run \code{\link[brms:make_standata]{brms::make_standata()}} and examine the \code{X} element
of the returned list. See the examples below for a
demonstration.
}

\examples{
set.seed(0)
data <- brm_data(
  data = brm_simulate_simple()$data,
  outcome = "response",
  role = "response",
  group = "group",
  time = "time",
  patient = "patient",
  reference_group = "group_1",
  reference_time = "time_1"
)
brm_formula(data)
brm_formula(data = data, intercept = FALSE, baseline = FALSE)
formula <- brm_formula(
  data = data,
  intercept = FALSE,
  baseline = FALSE,
  group = FALSE
)
formula
# Optional: set the contrast option, which determines the model matrix.
options(contrasts = c(unordered = "contr.SAS", ordered = "contr.poly"))
# See the fixed effect parameterization you get from the data:
head(brms::make_standata(formula = formula, data = data)$X)
# Specify a different contrast method to use an alternative
# parameterization when fitting the model with brm_model():
options(
  contrasts = c(unordered = "contr.treatment", ordered = "contr.poly")
)
# different model matrix than before:
head(brms::make_standata(formula = formula, data = data)$X)
}
\seealso{
Other models: 
\code{\link{brm_model}()}
}
\concept{models}
