% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brif.R
\name{brifTree.formula}
\alias{brifTree.formula}
\title{Build a single brif tree taking a formula as input}
\usage{
\method{brifTree}{formula}(
  formula,
  data,
  subset,
  na.action = stats::na.pass,
  depth = 3,
  n_cuts = 2047,
  max_integer_classes = 20,
  max_factor_levels = 30,
  seed = 0,
  ...
)
}
\arguments{
\item{formula}{an object of class "\code{\link[stats]{formula}}": a symbolic description of the model to be fitted.}

\item{data}{an optional data frame, list or environment (or object coercible by \code{\link{as.data.frame}} to a data frame) containing the variables in the model. If not found in \code{data}, the variables are taken from \code{environment(formula)}, typically the environment from which \code{brif.formula} is called.}

\item{subset}{an optional vector specifying a subset (in terms of index numbers, not actual data) of observations to be used in the fitting process.}

\item{na.action}{a function which indicates what should happen when the data contain NAs.}

\item{depth}{a positive integer indicating the desired depth of the tree.}

\item{n_cuts}{a positive integer indicating the maximum number of split points to generate on each numeric or integer variable. A large value is preferred for a single tree.}

\item{max_integer_classes}{a positive integer. See \code{\link[brif]{brif.default}} for details.}

\item{max_factor_levels}{a positive integer. See \code{\link[brif]{brif.default}} for details.}

\item{seed}{a non-negative positive integer specifying the random number generator seed.}

\item{...}{other relevant arguments.}
}
\value{
an object of class \code{brif} to be used by \code{\link{predict.brif}}.
}
\description{
Build a single brif tree taking a formula as input
}
