% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brglmFit.R
\name{summary.brglmFit}
\alias{summary.brglmFit}
\title{\code{summary} method for \code{\link{brglmFit}} objects}
\usage{
\method{summary}{brglmFit}(object, dispersion = NULL, correlation = FALSE,
  symbolic.cor = FALSE, ...)
}
\arguments{
\item{object}{an object of class \code{"glm"}, usually, a result of a
    call to \code{\link{glm}}.}

\item{dispersion}{the dispersion parameter for the family used.
    Either a single numerical value or \code{NULL} (the default), when
    it is inferred from \code{object} (see \sQuote{Details}).}

\item{correlation}{logical; if \code{TRUE}, the correlation matrix of
    the estimated parameters is returned and printed.}

\item{symbolic.cor}{logical. If \code{TRUE}, print the correlations in
    a symbolic form (see \code{\link{symnum}}) rather than as numbers.}

\item{...}{further arguments passed to or from other methods.}
}
\description{
\code{summary} method for \code{\link{brglmFit}} objects
}
\details{
The interface of the summary method for
    \code{\link{brglmFit}} objects is identical to that of
    \code{\link{glm}} objects. The summary method for
    \code{\link{brglmFit}} objects computes the p-values of the
    individual Wald statistics based on the standard normal
    distribution, unless the family is Gaussian, in which case a t
    distribution with appropriate degrees of freedom is used.
}
\examples{
## For examples see examples(brglmFit)

}
\seealso{
\code{\link{summary.glm}} and \code{\link{glm}}
}

