% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rich_club.R
\name{rich_core}
\alias{rich_core}
\title{Calculate the rich core of a graph}
\usage{
rich_core(g)
}
\arguments{
\item{g}{An \code{igraph} graph object}
}
\value{
A data frame with the following components:
\item{density}{The density of the graph.}
\item{rank}{The rank of the boundary for the rich core.}
\item{k.r}{The degree of the vertex at the boundary.}
\item{core.size}{The size of the core relative to the graph size.}
}
\description{
This function finds the boundary of the rich core of a graph, based on the
decreasing order of vertex degree. It also calculates the degree that
corresponds to that rank, and the core size relative to the total number of
vertices in the graph.
}
\references{
Ma A \& Mondragon R.J. (2015) \emph{Rich-cores in networks}. PLoS
One, 10(3): e0119678. doi:10.1371/journal.pone.0119678
}
\seealso{
Other Rich-club functions: \code{\link{plot_rich_norm}},
  \code{\link{rich_club_attrs}},
  \code{\link{rich_club_coeff}},
  \code{\link{rich_club_norm}}
}
\author{
Christopher G. Watson, \email{cgwatson@bu.edu}
}
