% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_vertex_measures.R
\name{plot_vertex_measures}
\alias{plot_vertex_measures}
\title{Plot vertex-level graph measures at a single density or threshold}
\usage{
plot_vertex_measures(tidy.dt, facet.by = "lobe", measure = "btwn.cent",
  show.points = FALSE, ylabel = NULL)
}
\arguments{
\item{tidy.dt}{A ``tidied'' \code{data.table} of vertex-level graph measures}

\item{facet.by}{Character string indicating whether the data should be
plotted separately by a certain variable (default: 'lobe')}

\item{measure}{A character string of the graph measure to plot (default:
'btwn.cent')}

\item{show.points}{Logical indicating whether or not to show individual data
points (default: FALSE)}

\item{ylabel}{A character string for the y-axis label}
}
\value{
A \code{ggplot} object
}
\description{
This function creates boxplots of a single vertex-level graph measure at a
single density or threshold, grouped by the variable specified by
\code{facet.by} (e.g., \emph{lobe} or \emph{network}).
}
\examples{
\dontrun{
ggp.btwn <- plot_vertex_measures(dt.V.tidy, facet.by='network',
  measure='E.nodal')
}
}
\author{
Christopher G. Watson, \email{cgwatson@bu.edu}
}
