% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot_global.R
\name{boot_global}
\alias{boot_global}
\title{Bootstrapping for global graph measures}
\usage{
boot_global(densities, resids, R = 1000, measure = c("mod", "E.global",
  "Cp", "Lp", "assortativity"))
}
\arguments{
\item{densities}{A vector of graph densities to loop through}

\item{resids}{A data.table of the residuals (from \code{\link{get.resid}})}

\item{R}{The number of bootstrap replicates (default: 1e3)}

\item{measure}{Character string of the measure to test (default: 'mod')}
}
\value{
A list with two elements:
\item{g}{A list of \code{\link[boot]{boot}} objects (one for each group)}
\item{dt}{A data table with length \emph{# densities * # groups}}
}
\description{
This function performs bootstrapping to get group standard error estimates of
a global graph measure (e.g. modularity). It will output a list containing
the \code{\link[boot]{boot}} objects and a \code{\link{data.table}} with
standard errors and 95\% confidence intervals at each density for each group.
}
\details{
The 95\% confidence intervals are calculated using the normal approximation.
}
\examples{
\dontrun{
boot.E.global <- boot_global(densities, m$resids, 1e3, 'E.global')
}
}
\author{
Christopher G. Watson, \email{cgwatson@bu.edu}
}
\seealso{
\code{\link[boot]{boot}, \link[boot]{boot.ci},
\link{permute.group}}
}

