% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/small_world.R
\name{small.world}
\alias{small.world}
\title{Calculate graph small-worldness}
\usage{
small.world(g, rand)
}
\arguments{
\item{g}{The graph (or list of graphs) of interest}

\item{rand}{List of (lists of) equivalent random graphs (output from
\code{\link{sim.rand.graph.par}})}
}
\value{
A data frame with the following components:
\item{density}{The range of density thresholds used.}
\item{N}{The number of random graphs that were generated.}
\item{Lp}{The characteristic path length.}
\item{Cp}{The clustering coefficient.}
\item{Lp.rand}{The mean characteristic path length of the random graphs with
the same degree distribution as g.}
\item{Cp.rand}{The mean clustering coefficient of the random graphs with
the same degree distribution as g.}
\item{Lp.norm}{The normalized characteristic path length.}
\item{Cp.norm}{The normalized clustering coefficient.}
\item{sigma}{The small-world measure of the graph.}
}
\description{
This function will calculate the characteristic path length and clustering
coefficient, which are used to calculate small-worldness.
}
\author{
Christopher G. Watson, \email{cgwatson@bu.edu}
}
\references{
Watts D.J., Strogatz S.H. (1998) \emph{Collective dynamics of
'small-world' networks}. Nature, 393:440-442.
}

