% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ORI.R
\name{qrnegLogLikensumOR1}
\alias{qrnegLogLikensumOR1}
\title{Negative log-likelihood in the OR1 model}
\usage{
qrnegLogLikensumOR1(y, x, betaOne, deltaOne, p)
}
\arguments{
\item{y}{observed ordinal outcomes, column vector of size \eqn{(n x 1)}.}

\item{x}{covariate matrix of size \eqn{(n x k)} including a column of ones with or without column names.}

\item{betaOne}{a sample draw of \eqn{\beta} of size \eqn{(k x 1)}.}

\item{deltaOne}{a sample draw of \eqn{\delta} of size \eqn{((J-2) x 1)}.}

\item{p}{quantile level or skewness parameter, p in (0,1).}
}
\value{
Returns a list with components
\itemize{
\item{\code{nlogl}: }{vector of negative log-likelihood values.}
\item{\code{negsumlogl}: }{negative sum of log-likelihood.}
}
}
\description{
This function computes the negative of log-likelihood for each individual and
negative sum of log-likelihood in the OR1 model.
}
\details{
This function computes the negative of log-likelihood for each individual and
negative sum of log-likelihood in the OR1 model.

The latter when evaluated at postMeanbeta and postMeandelta is used to calculate the DIC
and may also be utilized to calculate the Akaike information criterion (AIC) and the Bayesian information
criterion (BIC).
}
\examples{
set.seed(101)
deltaOne <- c(-0.002570995, 1.044481071)
data("data25j4")
y <- data25j4$y
xMat <- data25j4$x
p <- 0.25
betaOne <- c(0.3990094, 0.8168991, 2.8034963)
output <- qrnegLogLikensumOR1(y, xMat, betaOne, deltaOne, p)

# nlogl
#   0.7424858
#   1.1649645
#   2.1344390
#   0.9881085
#   2.7677386
#   0.8229129
#   0.8854911
#   0.3534490
#   1.8582422
#   0.9508680 .. soon

# negsumlogl
#   663.5475

}
\references{
Rahman, M. A. (2016). “Bayesian
Quantile Regression for Ordinal Models.”
Bayesian Analysis, 11(1): 1-24. DOI: 10.1214/15-BA939
}
\seealso{
likelihood maximization
}
