% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ODRI.R
\name{devianceg3}
\alias{devianceg3}
\title{Deviance Information Criteria for Ordinal Models
with more than 3 outcomes}
\usage{
devianceg3(y, x, deltastore, burn, iter, post_mean_beta, post_mean_delta,
  beta_draws, p)
}
\arguments{
\item{y}{dependent variable i.e. ordinal outcome values.}

\item{x}{covariate matrix of dimension \eqn{(n x k)} including a column of ones.}

\item{deltastore}{MCMC draws of \eqn{\delta}.}

\item{burn}{number of discarded MCMC iterations.}

\item{iter}{total number of samples, including the burn-in.}

\item{post_mean_beta}{mean value of \eqn{\beta} obtained from MCMC draws.}

\item{post_mean_delta}{mean value of \eqn{\delta} obtained from MCMC draws.}

\item{beta_draws}{MCMC draw of coeffcients, dimension is \eqn{(k x iter)}.}

\item{p}{quantile level or skewness parameter, p in (0,1).}
}
\value{
Returns a list with components
\deqn{DIC = 2*avgdeviance - devpostmean}
\deqn{pd = avgdeviance - devpostmean}
\deqn{devpostmean = -2*(logLikelihood)}.
}
\description{
Function for computing the Deviance Information Criteria for ordinal
models with more than 3 outcomes.
}
\details{
The Deviance is -2*(log likelihood) and has an important role in
statistical model comparision because of its relation with Kullback-Leibler
information criteria.
}
\examples{
set.seed(101)
data("data25j4")
x <- data25j4$x
y <- data25j4$y
p <- 0.25
ans <- quan_regg3(y, x, mc = 50, p, 0.1)
mc <- 50
deltastore <- ans$delta_draws
burn <- 0.25*mc
iter <- burn + mc
post_mean_beta <- ans$post_mean_beta
post_mean_delta <- ans$post_mean_delta
beta_draws <- ans$beta_draws
deviance <- devianceg3(y, x, deltastore, burn, iter,
post_mean_beta, post_mean_delta, beta_draws, p)

# DIC
#   616.2173
# pd
#   24.95203
# devpostmean
#   566.3133

}
\references{
Rahman, M. A. (2016). “Bayesian
Quantile Regression for Ordinal Models.”
Bayesian Analysis, 11(1): 1-24.

Spiegelhalter, D. J., Best, N. G., Carlin B. P. and Linde A. (2002).
“Bayesian Measures of Model Complexity and Fit.” Journal of the
Royal Statistical Society B, Part 4: 583-639.

Gelman, A., Carlin, J. B., Stern, H. S., and Rubin, D. B.
“Bayesian Data Analysis.” 2nd Edition, Chapman and Hall.
}
\seealso{
decision criteria
}
