% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BPLSR.R
\name{bplsr.predict}
\alias{bplsr.predict}
\title{Predict from a fitted BPLS regression model}
\usage{
bplsr.predict(model, newdata, PredInterval = 0.95)
}
\arguments{
\item{model}{Output of \code{bplsr}.}

\item{newdata}{Matrix of predictor variables to predict for.}

\item{PredInterval}{Intended coverage of prediction intervals (between 0 and 1). Setting the value to 0 only produces point predictions without prediction intervals.}
}
\value{
A list of:
\item{\code{Ytest}}{Point predictions for new responses; if \code{Xtest} is provided.}
\item{\code{Ytest_PI}}{Prediction intervals for new responses (by default 0.95 coverage); if \code{Xtest} is provided.}
\item{\code{Ytest_dist}}{Posterior predictive distributions for new responses; if \code{Xtest} is provided.}
}
\description{
Generates predictions from the fitted BPLS regression model using Monte Carlo simulation.
}
\details{
Predictions of the responses are generated from the posterior predictive distribution, marginalising out the model parameters; see Section 3.5 of Urbas et al. (2024).
}
\examples{
\donttest{
# data(milk_MIR)
X = milk_MIR$xMIR
Y = milk_MIR$yTraits[, c('Casein_content','Fat_content')]

set.seed(1)
# fit model to 25\% of data and predict on remaining 75\%
idx = sample(seq(nrow(X)),floor(nrow(X)*0.25),replace = FALSE)

Xtrain = X[idx,];Ytrain = Y[idx,]
Xtest = X[-idx,];Ytest = Y[-idx,]

# fit the model (for default MCMC settings leave Qs and N_MCMC blank; can take longer)
bplsr_Fit = bplsr(Xtrain,Ytrain, Qs = 10, N_MCMC = 5000)

# generate predictions
bplsr_pred = bplsr.predict(model = bplsr_Fit, newdata = Xtest)

# point predictions
head(bplsr_pred$Ytest)

# lower and upper limits of prediction interval
head(bplsr_pred$Ytest_PI)

# plot of predictive posterior distribution for single test sample
hist(bplsr_pred$Ytest_dist[1,'Casein_content',], freq = FALSE,
     main = 'Posterior predictive density', xlab = 'Casein_content')}
}
\references{
Urbas, S., Lovera, P., Daly, R., O'Riordan, A., Berry, D., and Gormley, I. C. (2024). "Predicting milk traits from spectral data using Bayesian probabilistic partial least squares regression." \emph{The Annals of Applied Statistics}, 18(4): 3486-3506. \if{html}{\out{<\doi{10.1214/24-AOAS1947}>}}
}
