% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bpc_get_probabilities.R
\name{get_probabilities}
\alias{get_probabilities}
\title{Get the empirical win/draw probabilities based on the ability/strength parameters.
Instead of calculating from the probability formula given from the model we create a predictive posterior distribution for all pair combinations and calculate the posterior wins/loose/draw
The function returns the mean value of win/loose/draw for the player i. To calculate for player j the probability is 1-p_i}
\usage{
get_probabilities(bpc_object, n = 1000)
}
\arguments{
\item{bpc_object}{a bpc object}

\item{n}{number of samples to draw from the posterior}
}
\value{
a list with data frame table with the respective probabilities and a matrix with the corresponding posterior
}
\description{
Get the empirical win/draw probabilities based on the ability/strength parameters.
Instead of calculating from the probability formula given from the model we create a predictive posterior distribution for all pair combinations and calculate the posterior wins/loose/draw
The function returns the mean value of win/loose/draw for the player i. To calculate for player j the probability is 1-p_i
}
\examples{
\donttest{
m<-bpc(data = tennis_agresti,
player0 = 'player0',
player1 = 'player1',
result_column = 'y',
model_type = 'bt',
solve_ties = 'none')
prob<-get_probabilities(m)
print(prob$Table)
}
}
