% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bpc_object.R
\name{create_bpc_object}
\alias{create_bpc_object}
\title{Defines the class bpc and creates the bpc object.
To create we need to receive some defined parameters (the arguments from the bpc function), a lookup table and a the stanfit
object generated from the rstan sampling procedure}
\usage{
create_bpc_object(
  stanfit,
  lookup_table,
  model_type,
  standata,
  call_arg,
  cluster_lookup_table = NULL,
  predictors_df = NULL,
  predictors_lookup_table = NULL,
  predictors_matrix = NULL
)
}
\arguments{
\item{stanfit}{Stanfit object returned by rstan::sampling}

\item{lookup_table}{lookup_table dataframe. Two columns one Index the other Names where each each index will match a string in the names}

\item{model_type}{the type of the model used to call stan (string)}

\item{standata}{a list with the data used to call the rstan::sampling procedure}

\item{call_arg}{a list with the arguments called from the bpc function}

\item{cluster_lookup_table}{a lookup table with we have random effects}

\item{predictors_df}{the data frame of the predictors for a generalized model}

\item{predictors_lookup_table}{a lookup table for generalized models}

\item{predictors_matrix}{a matrix of predictors for generalized models}
}
\value{
a bpc object
}
\description{
Defines the class bpc and creates the bpc object.
To create we need to receive some defined parameters (the arguments from the bpc function), a lookup table and a the stanfit
object generated from the rstan sampling procedure
}
