% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bp_visuals_ts_plot.R
\name{bp_ts_plots}
\alias{bp_ts_plots}
\title{Blood Pressure Time Series Plots}
\usage{
bp_ts_plots(
  data,
  index = NULL,
  subj = NULL,
  first_hour = 0,
  rotate_xlab = FALSE,
  wrap_var = NULL,
  wrap_row = NULL,
  wrap_col = NULL,
  method = NULL,
  formula = NULL
)
}
\arguments{
\item{data}{User-supplied data set containing blood pressure data. Must
contain a Systolic blood pressure (SBP), Diastolic blood pressure (DBP)
and an ID column. Data must also have either a DATE_TIME or DATE column,
unless an index column is specified for the x axis. An index column trumps
DATE_TIME and DATE if specified.}

\item{index}{An optional user-specified column denoting x-axis values (other
than DATE_TIME or DATE columns). \code{index} argument must be a character denoting a
column in the supplied data. This argument is useful in the event the
data has no corresponding date/time value, but rather an index of values
such as (reading #1, #2, #3, etc. or office visit #1, #2, etc. as examples)
If NULL, the function will look for DATE_TIME or DATE columns to reference.
If \code{index} is character, it will be coerced to factor.}

\item{subj}{Optional argument. Allows the user to specify and subset specific subjects
from the \code{ID} column of the supplied data set. The \code{subj} argument can be a single
value or a vector of elements. The input type should be character, but the function will
comply with integers so long as they are all present in the \code{ID} column of the data.}

\item{first_hour}{Optional argument denoting a value corresponding to the first hour of the
x-axis for the hour plots. Only applicable to data sets that contain a DATE_TIME column.
It is often easier to visualize a BP time series not from 0 - 23 hours but rather an order
that begins or ends with waking up such as \code{first_hour = 6} which will sequence the
hours from 6am (6, 7, ..., 23, 0, ..., 4, 5). The default value for \code{first_hour} is
set at 0}

\item{rotate_xlab}{An optional logical argument to rotate the x axis labels 90 degrees. The
default value is set to FALSE.}

\item{wrap_var}{An optional character argument indicating a column by which to "wrap" the data.
This function utilizes ggplot2's \code{facet_wrap} function to split plots according to some
extraneous variable (such as gender, smoking status, awake/asleep, etc.).}

\item{wrap_row}{An optional argument specifying how many rows to wrap the plots if \code{wrap_var}
is specified.}

\item{wrap_col}{An optional argument specifying how many columnss to wrap the plots if \code{wrap_var}
is specified.}

\item{method}{(ggplot2 plotting arguments) Smoothing method (function) to use. Default is NULL,
but also accepts a character vector "lm", "glm", "gam", "loess". NULL implies that the
smoothing method will be chosen automatically based on the size of the largest group.

See \url{https://ggplot2.tidyverse.org/reference/geom_smooth.html} for more details.}

\item{formula}{(ggplot2 plotting arguments) Formula to use in smoothing function. Default is NULL
implying y ~ x for fewer than 1,000 observations and y ~ x(x, bs = "cs") otherwise.

See \url{https://ggplot2.tidyverse.org/reference/geom_smooth.html} for more details.}
}
\value{
If the data does not contain a DATE_TIME column, a single list will be
returned with the time-dependent plots for each subject ID. If the data does contain a DATE_TIME
column (and index is not specified), a list of two lists will be returned for each subject ID:
one corresponding to the time-dependent plots (according to the DATE_TIME values), and another
plot corresponding to the HOUR plots which show repeated measurements of BP values throughout
a 24-hour period. The index of the output therefore corresponds to whether there is only the
time-dependent plot type (the former situation) or there are both time-dependent and hourly
plot types (the latter situation).
}
\description{
Blood Pressure Time Series Plots
}
\examples{
# Pregnancy Data Set

# bp_preg requires the use of the index argument since there are no DATE or
# DATE_TIME columns available
data_preg <- bp::bp_preg
data_preg$Time_Elapsed <- factor(data_preg$Time_Elapsed,
     levels = c("Booking", "0", "30", "60", "90", "120", "150", "180", "210", "240"))

bp::bp_ts_plots(data_preg, index = 'time_elapsed', subj = 1:3)


# JHS Data Set

# bp_jhs returns two lists since there is a DATE_TIME column: one for
# DATE_TIME and one for HOUR
data_jhs <- bp::process_data(bp::bp_jhs,
                                    sbp = 'sys.mmhg.',
                                    dbp = 'dias.mmhg.',
                                     hr = 'pulse.bpm.',
                              date_time = 'datetime')

bp::bp_ts_plots(data_jhs)


# HYPNOS Data Set

# bp_hypnos wraps the plots by the visit # since each subject was recorded over
# the course of two office visits
data_hypnos <- bp::process_data(bp::bp_hypnos,
                                          sbp = 'syst',
                                          dbp = 'diast',
                                    date_time = 'date.time')

bp::bp_ts_plots(data_hypnos, wrap_var = 'visit', subj = '70435')
}
