% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rangeDist_grass.R
\name{rangeDist_grass}
\alias{rangeDist_grass}
\title{Use GRASS to calcuate distance to range edge}
\usage{
rangeDist_grass(spdata, domain, domainkm = 1000, mask = T, verbose = T,
  clean = F, gisBase = NULL, file)
}
\arguments{
\item{spdata}{\code{list} object with range and points}

\item{domain}{Empty raster extent or path to geotif representing the potential modelling domain with resolution, projection, etc.}

\item{domainkm}{Distance threshold (in km) from expert range to set species \code{domain}.}

\item{mask}{\code{logical} indicating whether to mask the distance to values <= \code{domainkm}.}

\item{verbose}{\code{logical} indicating whether to print status messages.}

\item{clean}{\code{logical} indicating whether to delete all temporary GRASS files (the default) or keep them.  By default these files are in the current \code{tempdir()} and will be deleted when quitting R.}

\item{gisBase}{Path to GRASS Binaries as required by \code{\link[rgrass7]{initGRASS}}}

\item{file}{filename for output file exported from GRASS.}
}
\description{
Calculates distance to range boundary and returns a raster object.  Alternatively, one could use \code{raster::distance()} but it is very slow with large rasters.  This function uses GRASS (and requires grass to be available), but is much faster.
}

